/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.pool;

import ch.cyberduck.core.ConnectionService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.pool.StatelessSessionPool;
import ch.cyberduck.core.threading.BackgroundActionState;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class StatefulSessionPool
extends StatelessSessionPool {
    private static final Logger log = Logger.getLogger(StatefulSessionPool.class);
    private final Lock lock = new ReentrantLock();
    private final Session<?> session;

    public StatefulSessionPool(ConnectionService connect, Session<?> session, TranscriptListener transcript, VaultRegistry registry) {
        super(connect, session, transcript, registry);
        this.session = session;
    }

    @Override
    public Session<?> borrow(BackgroundActionState callback) throws BackgroundException {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Acquire lock for connection %s", this.session));
            }
            this.lock.lock();
        }
        catch (IllegalMonitorStateException e) {
            log.warn((Object)String.format("Failure acquiring lock for %s", this.session));
            throw new ConnectionCanceledException(e);
        }
        return super.borrow(callback);
    }

    @Override
    public void release(Session<?> conn, BackgroundException failure) {
        super.release(conn, failure);
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Release lock for connection %s", this.session));
            }
            this.lock.unlock();
        }
        catch (IllegalMonitorStateException ignored) {
            log.warn((Object)String.format("Failure releasing lock for %s", this.session));
        }
    }

    @Override
    public void evict() {
        super.evict();
        try {
            this.lock.unlock();
        }
        catch (IllegalMonitorStateException ignored) {
            log.warn((Object)String.format("Failure releasing lock for %s", this.session));
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        try {
            this.lock.unlock();
        }
        catch (IllegalMonitorStateException ignored) {
            log.warn((Object)String.format("Failure releasing lock for %s", this.session));
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StatefulSessionPool{");
        sb.append("lock=").append(this.lock);
        sb.append(", session=").append(this.session);
        sb.append('}');
        return sb.toString();
    }
}

