/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.synchronization;

import ch.cyberduck.core.Attributes;
import ch.cyberduck.core.date.CalendarService;
import ch.cyberduck.core.date.Instant;
import ch.cyberduck.core.synchronization.Comparison;
import ch.cyberduck.core.synchronization.ComparisonService;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class TimestampComparisonService
implements ComparisonService {
    private static final Logger log = Logger.getLogger(TimestampComparisonService.class);
    private final CalendarService calendarService;

    public TimestampComparisonService(TimeZone tz) {
        this.calendarService = new CalendarService(tz);
    }

    @Override
    public Comparison compare(Attributes remote, Attributes local) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Compare timestamp for %s with %s", remote, local));
        }
        if (-1L == remote.getModificationDate()) {
            log.warn((Object)String.format("No remote modification date available for comparison for %s", remote));
            return Comparison.unknown;
        }
        if (-1L == local.getModificationDate()) {
            log.warn((Object)String.format("No local modification date available for comparison for %s", local));
            return Comparison.unknown;
        }
        if (this.calendarService.asDate(local.getModificationDate(), Instant.SECOND).before(this.calendarService.asDate(remote.getModificationDate(), Instant.SECOND))) {
            return Comparison.remote;
        }
        if (this.calendarService.asDate(local.getModificationDate(), Instant.SECOND).after(this.calendarService.asDate(remote.getModificationDate(), Instant.SECOND))) {
            return Comparison.local;
        }
        return Comparison.equal;
    }
}

