/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.download;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.ChecksumComputeFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.download.AbstractDownloadFilter;
import ch.cyberduck.core.transfer.download.DownloadFilterOptions;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import org.apache.log4j.Logger;

public class ResumeFilter
extends AbstractDownloadFilter {
    private static final Logger log = Logger.getLogger(ResumeFilter.class);
    private final Download download;

    public ResumeFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session) {
        this(symlinkResolver, session, new DownloadFilterOptions());
    }

    public ResumeFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session, DownloadFilterOptions options) {
        this(symlinkResolver, session, options, session.getFeature(Download.class));
    }

    public ResumeFilter(SymlinkResolver<Path> symlinkResolver, Session<?> session, DownloadFilterOptions options, Download download) {
        super(symlinkResolver, session, options);
        this.download = download;
    }

    @Override
    public boolean accept(Path file, Local local, TransferStatus parent) throws BackgroundException {
        if (local.isFile() && local.exists()) {
            PathAttributes attributes = this.attribute.find(file);
            if (local.attributes().getSize() == attributes.getSize()) {
                if (Checksum.NONE != attributes.getChecksum()) {
                    ChecksumCompute compute = ChecksumComputeFactory.get(attributes.getChecksum().algorithm);
                    if (compute.compute(local.getInputStream(), parent).equals(attributes.getChecksum())) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Skip file %s with checksum %s", file, local.attributes().getChecksum()));
                        }
                        return false;
                    }
                    log.warn((Object)String.format("Checksum mismatch for %s and %s", file, local));
                } else {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Skip file %s with local size %d", file, local.attributes().getSize()));
                    }
                    return false;
                }
            }
        }
        return super.accept(file, local, parent);
    }

    @Override
    public TransferStatus prepare(Path file, Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        TransferStatus status = super.prepare(file, local, parent, progress);
        if (status.isSegmented()) {
            for (TransferStatus segmentStatus : status.getSegments()) {
                Local segmentFile = segmentStatus.getRename().local;
                if (!segmentFile.exists()) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Determine if part %s can be skipped", segmentStatus));
                }
                if (segmentFile.attributes().getSize() != segmentStatus.getLength()) continue;
                segmentStatus.setComplete();
                status.setLength(status.getLength() - segmentStatus.getLength());
                status.setOffset(status.getOffset() + segmentStatus.getLength());
            }
        } else if (this.download.offset(file) && local.isFile() && local.exists() && local.attributes().getSize() > 0L) {
            status.setAppend(true);
            status.setLength(status.getLength() - local.attributes().getSize());
            status.setOffset(status.getOffset() + local.attributes().getSize());
            status.rename((Local)null);
            if (status.getLength() == 0L) {
                status.setComplete();
            }
        }
        return status;
    }
}

