/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.symlink;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.local.LocalSymlinkFactory;
import ch.cyberduck.core.local.features.Symlink;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.symlink.AbstractSymlinkResolver;
import java.util.List;
import org.apache.log4j.Logger;

public class DownloadSymlinkResolver
extends AbstractSymlinkResolver<Path> {
    private static final Logger log = Logger.getLogger(DownloadSymlinkResolver.class);
    private final List<TransferItem> files;
    private final Symlink feature;

    public DownloadSymlinkResolver(List<TransferItem> files) {
        this.files = files;
        this.feature = LocalSymlinkFactory.get();
    }

    public DownloadSymlinkResolver(Symlink feature, List<TransferItem> files) {
        this.feature = feature;
        this.files = files;
    }

    @Override
    public boolean resolve(Path file) {
        if (PreferencesFactory.get().getBoolean("path.symboliclink.resolve")) {
            return false;
        }
        if (this.feature != null) {
            Path target = file.getSymlinkTarget();
            for (TransferItem root : this.files) {
                if (!this.findTarget(target, root.remote)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Resolved target %s for %s", target, file));
                }
                return true;
            }
        }
        return false;
    }

    private boolean findTarget(Path target, Path root) {
        return target.equals(root) || target.isChild(root);
    }
}

