/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class VaultRegistryDeleteFeature
implements Delete {
    private final Session<?> session;
    private final Delete proxy;
    private final VaultRegistry registry;

    public VaultRegistryDeleteFeature(Session<?> session, Delete proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        Vault vault;
        HashMap vaults = new HashMap();
        for (Map.Entry<Path, TransferStatus> entry : files.entrySet()) {
            vault = this.registry.find(this.session, entry.getKey());
            Map sorted = vaults.containsKey(vault) ? (Map)vaults.get(vault) : new LinkedHashMap();
            sorted.put(entry.getKey(), entry.getValue());
            vaults.put(vault, sorted);
        }
        for (Map.Entry<Path, TransferStatus> entry : vaults.entrySet()) {
            vault = (Vault)((Object)entry.getKey());
            Delete feature = vault.getFeature(this.session, Delete.class, this.proxy);
            feature.delete((Map)((Object)entry.getValue()), prompt, callback);
        }
    }

    @Override
    public boolean isSupported(Path file) {
        return this.proxy.isSupported(file);
    }

    @Override
    public boolean isRecursive() {
        return this.proxy.isRecursive();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryDeleteFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

