/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.Set;

public class VaultRegistryEncryptionFeature
implements Encryption {
    private final Session<?> session;
    private final Encryption proxy;
    private final VaultRegistry registry;

    public VaultRegistryEncryptionFeature(Session<?> session, Encryption proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public Set<Encryption.Algorithm> getKeys(Path file, LoginCallback prompt) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Encryption.class, this.proxy).getKeys(file, prompt);
    }

    @Override
    public Encryption.Algorithm getEncryption(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Encryption.class, this.proxy).getEncryption(file);
    }

    @Override
    public void setEncryption(Path file, Encryption.Algorithm algorithm) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, Encryption.class, this.proxy).setEncryption(file, algorithm);
    }

    @Override
    public Encryption.Algorithm getDefault(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Encryption.class, this.proxy).getDefault(file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryEncryptionFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

