/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;

public class ListEncryptionKeysWorker
extends Worker<Set<Encryption.Algorithm>> {
    private static final Logger log = Logger.getLogger(ListEncryptionKeysWorker.class);
    private final List<Path> files;
    private final LoginCallback prompt;

    public ListEncryptionKeysWorker(List<Path> files, LoginCallback prompt) {
        this.files = files;
        this.prompt = prompt;
    }

    @Override
    public Set<Encryption.Algorithm> run(Session<?> session) throws BackgroundException {
        Encryption feature = session.getFeature(Encryption.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Run with feature %s", feature));
        }
        HashSet<Encryption.Algorithm> keys = new HashSet<Encryption.Algorithm>();
        for (Path file : this.getContainers(this.files)) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            keys.addAll(feature.getKeys(file, this.prompt));
        }
        return keys;
    }

    @Override
    public Set<Encryption.Algorithm> initialize() {
        return Collections.emptySet();
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Reading metadata of {0}", "Status"), this.toString(this.files));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListEncryptionKeysWorker that = (ListEncryptionKeysWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ReadEncryptionKeysWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

