/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Restore;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;

public class RestoreWorker
extends Worker<List<Path>> {
    private static final Logger log = Logger.getLogger(RestoreWorker.class);
    private final List<Path> files;
    private final LoginCallback prompt;

    public RestoreWorker(LoginCallback prompt, List<Path> files) {
        this.files = files;
        this.prompt = prompt;
    }

    @Override
    public List<Path> run(Session<?> session) throws BackgroundException {
        Restore feature = session.getFeature(Restore.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Run with feature %s", feature));
        }
        for (Path file : this.files) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            feature.restore(file, this.prompt);
        }
        return this.files;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Reverting {0}", "Status"), this.toString(this.files));
    }

    @Override
    public List<Path> initialize() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreWorker that = (RestoreWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("RestoreWorker{");
        sb.append("files=").append(this.files);
        sb.append(", prompt=").append(this.prompt);
        sb.append('}');
        return sb.toString();
    }
}

