/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.ListCanceledException;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.Objects;
import org.apache.log4j.Logger;

public class SessionListWorker
extends Worker<AttributedList<Path>> {
    private static final Logger log = Logger.getLogger(SessionListWorker.class);
    private final Cache<Path> cache;
    private final Path directory;
    private final ListProgressListener listener;

    public SessionListWorker(Cache<Path> cache, Path directory, ListProgressListener listener) {
        this.cache = cache;
        this.directory = directory;
        this.listener = new ConnectionCancelListProgressListener(this, directory, listener);
    }

    @Override
    public AttributedList<Path> run(Session<?> session) throws BackgroundException {
        try {
            if (this.isCached()) {
                AttributedList<Path> list = this.cache.get(this.directory);
                this.listener.chunk(this.directory, list);
                return list;
            }
            ListService service = session.getFeature(ListService.class).withCache(this.cache);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Run with feature %s", service));
            }
            return service.list(this.directory, this.listener);
        }
        catch (ListCanceledException e) {
            return e.getChunk();
        }
    }

    protected boolean isCached() {
        return this.cache.isValid(this.directory);
    }

    @Override
    public void cleanup(AttributedList<Path> list) {
        if (AttributedList.emptyList() != list) {
            this.cache.put(this.directory, list);
        }
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Listing directory {0}", "Status"), this.directory.getName());
    }

    @Override
    public AttributedList<Path> initialize() {
        return AttributedList.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionListWorker that = (SessionListWorker)o;
        return Objects.equals(this.directory, that.directory);
    }

    public int hashCode() {
        return this.directory != null ? this.directory.hashCode() : 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("SessionListWorker{");
        sb.append("directory=").append(this.directory);
        sb.append('}');
        return sb.toString();
    }

    private static final class ConnectionCancelListProgressListener
    implements ListProgressListener {
        private final Worker worker;
        private final Path directory;
        private final ListProgressListener proxy;

        public ConnectionCancelListProgressListener(Worker worker, Path directory, ListProgressListener proxy) {
            this.worker = worker;
            this.directory = directory;
            this.proxy = proxy;
        }

        @Override
        public void chunk(Path parent, AttributedList<Path> list) throws ConnectionCanceledException {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Retrieved chunk of %d items in %s", list.size(), this.directory));
            }
            if (this.worker.isCanceled()) {
                throw new ListCanceledException(list);
            }
            this.proxy.chunk(this.directory, list);
        }

        @Override
        public ListProgressListener reset() {
            return this.proxy.reset();
        }

        @Override
        public void message(String message) {
            this.proxy.message(message);
        }
    }
}

