/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.multipart;

import com.joyent.manta.client.multipart.MultipartOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.UUID;
import javax.crypto.Cipher;

class EncryptionStateSnapshot {
    private final UUID uploadId;
    private final int lastPartNumber;
    private final boolean lastPartAuthWritten;
    private final Cipher cipher;
    private final OutputStream cipherStream;
    private final MultipartOutputStream multipartStream;

    EncryptionStateSnapshot(UUID uploadId, int lastPartNumber, boolean lastPartAuthWritten, Cipher cipher, OutputStream cipherStream, MultipartOutputStream multipartStream) {
        this.uploadId = uploadId;
        this.lastPartNumber = lastPartNumber;
        this.lastPartAuthWritten = lastPartAuthWritten;
        this.cipher = cipher;
        this.cipherStream = cipherStream;
        this.multipartStream = multipartStream;
    }

    UUID getUploadId() {
        return this.uploadId;
    }

    int getLastPartNumber() {
        return this.lastPartNumber;
    }

    Cipher getCipher() {
        return this.cipher;
    }

    OutputStream getCipherStream() {
        return this.cipherStream;
    }

    MultipartOutputStream getMultipartStream() {
        return this.multipartStream;
    }

    boolean getLastPartAuthWritten() {
        return this.lastPartAuthWritten;
    }

    public int hashCode() {
        return Objects.hash(this.uploadId, this.lastPartNumber, this.lastPartAuthWritten);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EncryptionStateSnapshot)) {
            return false;
        }
        EncryptionStateSnapshot that = (EncryptionStateSnapshot)o;
        return Objects.equals(this.uploadId, that.uploadId) && this.lastPartNumber == that.lastPartNumber && this.lastPartAuthWritten == that.lastPartAuthWritten;
    }
}

