/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.http.entity;

import com.joyent.manta.http.entity.MemoryBackedEntity;
import com.joyent.manta.util.MantaUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.io.DigestOutputStream;

public class DigestedEntity
implements HttpEntity {
    private final Digest digest;
    private final HttpEntity wrapped;

    public DigestedEntity(HttpEntity wrapped, Digest digest) {
        this.wrapped = wrapped;
        this.digest = digest;
    }

    public boolean isRepeatable() {
        return this.wrapped.isRepeatable();
    }

    public boolean isChunked() {
        return this.wrapped.isChunked();
    }

    public long getContentLength() {
        return this.wrapped.getContentLength();
    }

    public Header getContentType() {
        return this.wrapped.getContentType();
    }

    public Header getContentEncoding() {
        return null;
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        return this.wrapped.getContent();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.digest.reset();
        if (this.wrapped instanceof MemoryBackedEntity) {
            MemoryBackedEntity entity = (MemoryBackedEntity)this.wrapped;
            ByteBuffer backingBuffer = entity.getBackingBuffer();
            if (backingBuffer.hasArray()) {
                byte[] bytes = backingBuffer.array();
                int offset = backingBuffer.arrayOffset();
                int position = backingBuffer.position();
                int limit = backingBuffer.limit();
                this.digest.update(bytes, offset + position, limit - position);
                backingBuffer.position(limit);
                this.wrapped.writeTo(out);
            }
        } else {
            try (DigestOutputStream dout = new DigestOutputStream(this.digest);
                 TeeOutputStream teeOut = new TeeOutputStream(out, (OutputStream)dout);){
                this.wrapped.writeTo((OutputStream)teeOut);
                teeOut.flush();
            }
        }
    }

    public boolean isStreaming() {
        return this.wrapped.isStreaming();
    }

    public void consumeContent() throws IOException {
        this.wrapped.consumeContent();
    }

    public byte[] getDigest() {
        byte[] res = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(res, 0);
        return res;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("digest", (Object)MantaUtils.byteArrayAsHexString(this.getDigest())).append("wrapped", (Object)this.wrapped).toString();
    }
}

