/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import org.jets3t.gui.JHtmlLabel;
import org.jets3t.gui.TableSorter;
import org.jets3t.gui.skins.SkinsFactory;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3Object;

public class CopyObjectsDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1131752874387139972L;
    private SkinsFactory skinsFactory = null;
    private final Insets insetsZero = new Insets(0, 0, 0, 0);
    private final Insets insetsDefault = new Insets(5, 7, 5, 7);
    private final Insets insetsHorizontalSpace = new Insets(0, 7, 0, 7);
    private S3Object[] destinationObjects = null;
    private String[] sourceObjectKeys = null;
    private S3Bucket[] buckets = null;
    private String sourceBucketName = null;
    private JTextField renamePatternTextField = null;
    private JButton okButton = null;
    private JPanel warningPanel = null;
    private DefaultTableModel previewTableModel = null;
    private JTable previewTable = null;
    private JComboBox destinationBucketComboBox = null;
    private JComboBox destinationAclComboBox = null;
    private JComboBox destinationStorageClassComboBox = null;
    private JCheckBox moveObjectsCheckBox = null;
    private boolean copyActionApproved = false;
    private boolean copyOriginalAccessControlLists = false;

    public CopyObjectsDialog(Frame owner, String title, SkinsFactory skinsFactory, S3Object[] objects, S3Bucket[] buckets) {
        super(owner, title, true);
        int i;
        this.skinsFactory = skinsFactory;
        this.buckets = buckets;
        this.destinationObjects = new S3Object[objects.length];
        for (i = 0; i < objects.length; ++i) {
            this.destinationObjects[i] = (S3Object)objects[i].clone();
        }
        this.sourceObjectKeys = new String[objects.length];
        for (i = 0; i < objects.length; ++i) {
            this.sourceObjectKeys[i] = objects[i].getKey();
        }
        this.sourceBucketName = this.destinationObjects[0].getBucketName();
        this.initGui();
    }

    private void initGui() {
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        JPanel optionsPanel = this.skinsFactory.createSkinnedJPanel("CopyObjectsDialogOptionsPanel");
        optionsPanel.setLayout(new GridBagLayout());
        this.destinationBucketComboBox = this.skinsFactory.createSkinnedJComboBox("DestinationBucketComboBox");
        for (int i = 0; i < this.buckets.length; ++i) {
            this.destinationBucketComboBox.addItem(this.buckets[i].getName());
        }
        this.destinationBucketComboBox.setSelectedItem(this.sourceBucketName);
        JHtmlLabel destinationBucketLabel = this.skinsFactory.createSkinnedJHtmlLabel("DestinationBucketLabel");
        destinationBucketLabel.setText("Copy to Bucket:");
        JPanel bucketPanel = this.skinsFactory.createSkinnedJPanel("CopyObjectsDialogBucketPanel");
        bucketPanel.setLayout(new GridBagLayout());
        bucketPanel.add((Component)destinationBucketLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, this.insetsZero, 0, 0));
        bucketPanel.add((Component)this.destinationBucketComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, this.insetsZero, 0, 0));
        this.destinationAclComboBox = this.skinsFactory.createSkinnedJComboBox("DestinationAclComboBox");
        this.destinationAclComboBox.addItem("Unchanged");
        this.destinationAclComboBox.addItem("Private");
        this.destinationAclComboBox.addItem("Publically Accessible");
        JHtmlLabel destinationAclLabel = this.skinsFactory.createSkinnedJHtmlLabel("DestinationAclLabel");
        destinationAclLabel.setText("Access permissions for copied objects: ");
        JPanel aclPanel = this.skinsFactory.createSkinnedJPanel("CopyObjectsDialogAclPanel");
        aclPanel.setLayout(new GridBagLayout());
        aclPanel.add((Component)destinationAclLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, this.insetsZero, 0, 0));
        aclPanel.add((Component)this.destinationAclComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, this.insetsZero, 0, 0));
        this.destinationStorageClassComboBox = this.skinsFactory.createSkinnedJComboBox("DestinationStorageClassComboBox");
        this.destinationStorageClassComboBox.addItem("STANDARD");
        this.destinationStorageClassComboBox.addItem("REDUCED_REDUNDANCY");
        JHtmlLabel destinationStorageClassLabel = this.skinsFactory.createSkinnedJHtmlLabel("DestinationStorageClassLabel");
        destinationStorageClassLabel.setText("Storage Class for copied objects: ");
        JPanel storageClassPanel = this.skinsFactory.createSkinnedJPanel("CopyObjectsDialogStorageClassPanel");
        storageClassPanel.setLayout(new GridBagLayout());
        storageClassPanel.add((Component)destinationStorageClassLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, this.insetsZero, 0, 0));
        storageClassPanel.add((Component)this.destinationStorageClassComboBox, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, this.insetsZero, 0, 0));
        this.moveObjectsCheckBox = this.skinsFactory.createSkinnedJCheckBox("MoveObjectsCheckBox");
        this.moveObjectsCheckBox.setSelected(false);
        this.moveObjectsCheckBox.setText("Move Objects  (Originals will be deleted after copy)");
        JRadioButton unchangedNamesRadioButton = this.skinsFactory.createSkinnedJRadioButton("UnchangedObjectNamesRadioButton");
        unchangedNamesRadioButton.setText("Leave object names unchanged");
        unchangedNamesRadioButton.setSelected(true);
        final JRadioButton changedNamesRadioButton = this.skinsFactory.createSkinnedJRadioButton("ChangedObjectNamesRadioButton");
        changedNamesRadioButton.setText("Rename objects with pattern:");
        this.renamePatternTextField = this.skinsFactory.createSkinnedJTextField("RenamePatternTextField");
        this.renamePatternTextField.setEnabled(false);
        this.renamePatternTextField.setText(this.destinationObjects.length == 1 ? this.destinationObjects[0].getKey() : "{key}");
        this.renamePatternTextField.setToolTipText("Use variables to rename your objects: {key}  {path}  {filename}  {basename}  {ext}  {count}");
        this.renamePatternTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                CopyObjectsDialog.this.refreshNamesPreviewTable();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                CopyObjectsDialog.this.refreshNamesPreviewTable();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CopyObjectsDialog.this.refreshNamesPreviewTable();
            }
        });
        changedNamesRadioButton.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (changedNamesRadioButton.isSelected()) {
                    CopyObjectsDialog.this.renamePatternTextField.setEnabled(true);
                    CopyObjectsDialog.this.renamePatternTextField.requestFocus();
                } else {
                    CopyObjectsDialog.this.renamePatternTextField.setText(CopyObjectsDialog.this.destinationObjects.length == 1 ? CopyObjectsDialog.this.destinationObjects[0].getKey() : "{key}");
                    CopyObjectsDialog.this.renamePatternTextField.setEnabled(false);
                }
            }
        });
        ButtonGroup radioButtonGroup = new ButtonGroup();
        radioButtonGroup.add(unchangedNamesRadioButton);
        radioButtonGroup.add(changedNamesRadioButton);
        JPanel renamePanel = this.skinsFactory.createSkinnedJPanel("CopyObjectsDialogRenamePanel");
        renamePanel.setLayout(new GridBagLayout());
        renamePanel.add((Component)unchangedNamesRadioButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, this.insetsZero, 0, 0));
        renamePanel.add((Component)changedNamesRadioButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, this.insetsZero, 0, 0));
        int textOffset = changedNamesRadioButton.getIconTextGap() + (int)changedNamesRadioButton.getPreferredSize().getHeight();
        renamePanel.add((Component)this.renamePatternTextField, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, textOffset, 0, 0), 0, 0));
        this.previewTableModel = new DefaultTableModel(new Object[]{"Object Key"}, 0){
            private static final long serialVersionUID = -2859341917353477009L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        TableSorter previewTableSorter = new TableSorter(this.previewTableModel);
        previewTableSorter.setSortingStatus(0, 1);
        this.previewTable = this.skinsFactory.createSkinnedJTable("MetadataTable");
        this.previewTable.setModel(previewTableSorter);
        previewTableSorter.setTableHeader(this.previewTable.getTableHeader());
        JHtmlLabel copyPreviewTableLabel = this.skinsFactory.createSkinnedJHtmlLabel("CopyObjectsDialogCopyPreviewLabel");
        copyPreviewTableLabel.setText("<html><b>Copy Preview</b></html>");
        copyPreviewTableLabel.setHorizontalAlignment(0);
        this.okButton = this.skinsFactory.createSkinnedJButton("CopyObjectsDialogOKButton");
        this.okButton.setText("Copy Object" + (this.destinationObjects.length > 0 ? "s" : ""));
        this.okButton.setActionCommand("OK");
        this.okButton.addActionListener(this);
        this.okButton.setEnabled(false);
        this.moveObjectsCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (CopyObjectsDialog.this.moveObjectsCheckBox.isSelected()) {
                    CopyObjectsDialog.this.okButton.setText("Move Object" + (CopyObjectsDialog.this.destinationObjects.length > 0 ? "s" : ""));
                } else {
                    CopyObjectsDialog.this.okButton.setText("Copy Object" + (CopyObjectsDialog.this.destinationObjects.length > 0 ? "s" : ""));
                }
            }
        });
        JButton cancelButton = this.skinsFactory.createSkinnedJButton("CopyObjectsDialogCancelButton");
        cancelButton.setText("Cancel");
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        this.warningPanel = this.skinsFactory.createSkinnedJPanel("CopyObjectsDialogWarningPanel");
        this.warningPanel.setLayout(new GridBagLayout());
        JHtmlLabel warningLabel = this.skinsFactory.createSkinnedJHtmlLabel("CopyObjectsDialogWarningLabel");
        warningLabel.setText("<html><font color=red>ERROR:</font> Object renaming pattern is causing key name clashes.</html>");
        warningLabel.setHorizontalAlignment(0);
        this.warningPanel.add((Component)warningLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, this.insetsZero, 0, 0));
        JPanel actionButtonsPanel = this.skinsFactory.createSkinnedJPanel("CopoyObjectsDialogActionButtonsPanel");
        actionButtonsPanel.setLayout(new GridBagLayout());
        actionButtonsPanel.add((Component)cancelButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, this.insetsHorizontalSpace, 0, 0));
        actionButtonsPanel.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, this.insetsHorizontalSpace, 0, 0));
        int row = 0;
        optionsPanel.add((Component)bucketPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        optionsPanel.add((Component)aclPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        optionsPanel.add((Component)storageClassPanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        optionsPanel.add((Component)this.moveObjectsCheckBox, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, this.insetsHorizontalSpace, 0, 0));
        optionsPanel.add((Component)renamePanel, new GridBagConstraints(0, row++, 1, 1, 1.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        optionsPanel.add((Component)copyPreviewTableLabel, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        optionsPanel.add((Component)new JScrollPane(this.previewTable), new GridBagConstraints(0, row++, 2, 1, 1.0, 1.0, 10, 1, this.insetsHorizontalSpace, 0, 0));
        optionsPanel.add((Component)this.warningPanel, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        optionsPanel.add((Component)actionButtonsPanel, new GridBagConstraints(0, row++, 2, 1, 0.0, 0.0, 10, 2, this.insetsDefault, 0, 0));
        this.getRootPane().setDefaultButton(this.okButton);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){
            private static final long serialVersionUID = 921962767729511631L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CopyObjectsDialog.this.setVisible(false);
            }
        });
        this.getContentPane().add(optionsPanel);
        this.pack();
        this.setSize(450, 400);
        this.setLocationRelativeTo(this.getOwner());
        this.refreshNamesPreviewTable();
    }

    protected Set renameObjectKeys(S3Object[] objects) {
        HashSet<String> newNames = new HashSet<String>();
        for (int i = 0; i < objects.length; ++i) {
            String newName = this.renameObjectKey(objects[i].getKey(), i);
            newNames.add(newName);
        }
        return newNames;
    }

    protected String renameObjectKey(String key, int offset) {
        String count = "" + (offset + 1);
        String filename = key;
        String path = "";
        int lastSlash = key.lastIndexOf(47);
        if (lastSlash >= 0) {
            path = key.substring(0, lastSlash + 1);
            filename = key.substring(lastSlash + 1);
        }
        String basename = filename;
        String ext = "";
        int lastPeriod = filename.lastIndexOf(46);
        if (lastPeriod >= 0) {
            basename = filename.substring(0, lastPeriod);
            ext = filename.substring(lastPeriod + 1);
        }
        String newName = this.renamePatternTextField.getText();
        newName = newName.replaceAll("\\{key\\}", Matcher.quoteReplacement(key));
        newName = newName.replaceAll("\\{count\\}", Matcher.quoteReplacement(count));
        newName = newName.replaceAll("\\{path\\}", Matcher.quoteReplacement(path));
        newName = newName.replaceAll("\\{filename\\}", Matcher.quoteReplacement(filename));
        newName = newName.replaceAll("\\{ext\\}", Matcher.quoteReplacement(ext));
        newName = newName.replaceAll("\\{basename\\}", Matcher.quoteReplacement(basename));
        return newName;
    }

    protected void refreshNamesPreviewTable() {
        while (this.previewTableModel.getRowCount() > 0) {
            this.previewTableModel.removeRow(0);
        }
        Set renamedKeys = this.renameObjectKeys(this.destinationObjects);
        Iterator nameIter = renamedKeys.iterator();
        while (nameIter.hasNext()) {
            this.previewTableModel.addRow(new Object[]{nameIter.next()});
        }
        if (this.destinationObjects.length != renamedKeys.size()) {
            this.okButton.setEnabled(false);
            this.warningPanel.setVisible(true);
        } else {
            this.okButton.setEnabled(true);
            this.warningPanel.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("OK".equals(e.getActionCommand())) {
            this.copyActionApproved = true;
            for (int i = 0; i < this.destinationObjects.length; ++i) {
                this.destinationObjects[i].setKey(this.renameObjectKey(this.destinationObjects[i].getKey(), i));
                if ("Publically Accessible".equals(this.destinationAclComboBox.getSelectedItem())) {
                    this.destinationObjects[i].setAcl(AccessControlList.REST_CANNED_PUBLIC_READ);
                } else if ("Unchanged".equals(this.destinationAclComboBox.getSelectedItem())) {
                    this.copyOriginalAccessControlLists = true;
                }
                this.destinationObjects[i].setStorageClass((String)this.destinationStorageClassComboBox.getSelectedItem());
            }
            this.setVisible(false);
        } else if ("Cancel".equals(e.getActionCommand())) {
            this.copyActionApproved = false;
            this.setVisible(false);
        }
    }

    public boolean isCopyActionApproved() {
        return this.copyActionApproved;
    }

    public boolean isMoveOptionSelected() {
        return this.moveObjectsCheckBox.isSelected();
    }

    public boolean isCopyOriginalAccessControlLists() {
        return this.copyOriginalAccessControlLists;
    }

    public String[] getSourceObjectKeys() {
        if (!this.isCopyActionApproved()) {
            return null;
        }
        return this.sourceObjectKeys;
    }

    public S3Object[] getDestinationObjects() {
        if (!this.isCopyActionApproved()) {
            return null;
        }
        return this.destinationObjects;
    }

    public String getDestinationBucketName() {
        if (!this.isCopyActionApproved()) {
            return null;
        }
        return (String)this.destinationBucketComboBox.getSelectedItem();
    }
}

