/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.response;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import synapticloop.b2.Action;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.BaseB2Response;

public class B2HideFileResponse
extends BaseB2Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(B2HideFileResponse.class);
    private final String fileId = this.readString("fileId");
    private final String fileName = this.readString("fileName");
    private final String accountId = this.readString("accountId");
    private final String bucketId = this.readString("bucketId");
    private Action action;
    private final Integer size;
    private final Long uploadTimestamp;
    private final Long contentLength;
    private final String contentType;
    private final String contentSha1;
    private final Map<String, String> fileInfo;

    public B2HideFileResponse(String json) throws B2ApiException {
        super(json);
        String action = this.readString("action");
        if (null != action) {
            try {
                this.action = Action.valueOf(action);
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn("Unknown action value " + action);
            }
        }
        this.size = this.readInt("size");
        this.uploadTimestamp = this.readLong("uploadTimestamp");
        this.contentLength = this.readLong("contentLength");
        this.contentType = this.readString("contentType");
        this.contentSha1 = this.readString("contentSha1");
        this.fileInfo = this.readMap("fileInfo");
        this.warnOnMissedKeys();
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public Action getAction() {
        return this.action;
    }

    public Integer getSize() {
        return this.size;
    }

    public Long getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("B2HideFileResponse{");
        sb.append("fileId='").append(this.fileId).append('\'');
        sb.append(", fileName='").append(this.fileName).append('\'');
        sb.append(", action=").append((Object)this.action);
        sb.append(", size=").append(this.size);
        sb.append('}');
        return sb.toString();
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentSha1() {
        return this.contentSha1;
    }

    public Map<String, String> getFileInfo() {
        return this.fileInfo;
    }
}

