/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetTapePartitionFailuresSpectraS3Response;
import com.spectralogic.ds3client.models.TapePartitionFailureList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class GetTapePartitionFailuresSpectraS3ResponseParser
extends AbstractResponseParser<GetTapePartitionFailuresSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetTapePartitionFailuresSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        Integer pagingTruncated = this.parseIntHeader("page-truncated");
        Integer pagingTotalResultCount = this.parseIntHeader("total-result-count");
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        TapePartitionFailureList result = XmlOutput.fromXml(inputStream, TapePartitionFailureList.class);
                        GetTapePartitionFailuresSpectraS3Response getTapePartitionFailuresSpectraS3Response = new GetTapePartitionFailuresSpectraS3Response(result, pagingTotalResultCount, pagingTruncated, this.getChecksum(), this.getChecksumType());
                        return getTapePartitionFailuresSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

