/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.ReplicatePutJobSpectraS3Response;
import com.spectralogic.ds3client.models.MasterObjectList;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import java.io.IOException;
import java.io.InputStream;

public class ReplicatePutJobSpectraS3ResponseParser
extends AbstractResponseParser<ReplicatePutJobSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200, 204};

    @Override
    public ReplicatePutJobSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        MasterObjectList result = XmlOutput.fromXml(inputStream, MasterObjectList.class);
                        ReplicatePutJobSpectraS3Response replicatePutJobSpectraS3Response = new ReplicatePutJobSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return replicatePutJobSpectraS3Response;
                    }
                }
                case 204: {
                    return new ReplicatePutJobSpectraS3Response(null, this.getChecksum(), this.getChecksumType());
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

