/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.PoolHealth;
import com.spectralogic.ds3client.models.PoolState;
import com.spectralogic.ds3client.models.PoolType;
import com.spectralogic.ds3client.models.TapeState;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetBucketCapacitySummarySpectraS3Request
extends AbstractRequest {
    private final String bucketId;
    private final String storageDomainId;
    private PoolHealth poolHealth;
    private PoolState poolState;
    private PoolType poolType;
    private TapeState tapeState;
    private String tapeType;

    public GetBucketCapacitySummarySpectraS3Request(String bucketId, UUID storageDomainId) {
        this.bucketId = bucketId;
        this.storageDomainId = storageDomainId.toString();
        this.updateQueryParam("bucket_id", bucketId);
        this.updateQueryParam("storage_domain_id", storageDomainId);
    }

    public GetBucketCapacitySummarySpectraS3Request(String bucketId, String storageDomainId) {
        this.bucketId = bucketId;
        this.storageDomainId = storageDomainId;
        this.updateQueryParam("bucket_id", bucketId);
        this.updateQueryParam("storage_domain_id", storageDomainId);
    }

    public GetBucketCapacitySummarySpectraS3Request withPoolHealth(PoolHealth poolHealth) {
        this.poolHealth = poolHealth;
        this.updateQueryParam("pool_health", poolHealth);
        return this;
    }

    public GetBucketCapacitySummarySpectraS3Request withPoolState(PoolState poolState) {
        this.poolState = poolState;
        this.updateQueryParam("pool_state", poolState);
        return this;
    }

    public GetBucketCapacitySummarySpectraS3Request withPoolType(PoolType poolType) {
        this.poolType = poolType;
        this.updateQueryParam("pool_type", poolType);
        return this;
    }

    public GetBucketCapacitySummarySpectraS3Request withTapeState(TapeState tapeState) {
        this.tapeState = tapeState;
        this.updateQueryParam("tape_state", tapeState);
        return this;
    }

    public GetBucketCapacitySummarySpectraS3Request withTapeType(String tapeType) {
        this.tapeType = tapeType;
        this.updateQueryParam("tape_type", tapeType);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/capacity_summary";
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public PoolHealth getPoolHealth() {
        return this.poolHealth;
    }

    public PoolState getPoolState() {
        return this.poolState;
    }

    public PoolType getPoolType() {
        return this.poolType;
    }

    public TapeState getTapeState() {
        return this.tapeState;
    }

    public String getTapeType() {
        return this.tapeType;
    }
}

