/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetUsersSpectraS3Request
extends AbstractPaginationRequest {
    private String authId;
    private String defaultDataPolicyId;
    private boolean lastPage;
    private String name;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;

    public GetUsersSpectraS3Request withAuthId(String authId) {
        this.authId = authId;
        this.updateQueryParam("auth_id", authId);
        return this;
    }

    public GetUsersSpectraS3Request withDefaultDataPolicyId(UUID defaultDataPolicyId) {
        this.defaultDataPolicyId = defaultDataPolicyId.toString();
        this.updateQueryParam("default_data_policy_id", defaultDataPolicyId);
        return this;
    }

    public GetUsersSpectraS3Request withDefaultDataPolicyId(String defaultDataPolicyId) {
        this.defaultDataPolicyId = defaultDataPolicyId;
        this.updateQueryParam("default_data_policy_id", defaultDataPolicyId);
        return this;
    }

    public GetUsersSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetUsersSpectraS3Request withName(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
        return this;
    }

    public GetUsersSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetUsersSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetUsersSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetUsersSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/user";
    }

    public String getAuthId() {
        return this.authId;
    }

    public String getDefaultDataPolicyId() {
        return this.defaultDataPolicyId;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public String getName() {
        return this.name;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }
}

