/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.DataReplicationRuleType;
import com.spectralogic.ds3client.models.S3InitialDataPlacementPolicy;
import com.spectralogic.ds3client.networking.HttpVerb;

public class ModifyS3DataReplicationRuleSpectraS3Request
extends AbstractRequest {
    private final String s3DataReplicationRule;
    private S3InitialDataPlacementPolicy initialDataPlacement;
    private long maxBlobPartSizeInBytes;
    private boolean replicateDeletes;
    private DataReplicationRuleType type;

    public ModifyS3DataReplicationRuleSpectraS3Request(String s3DataReplicationRule) {
        this.s3DataReplicationRule = s3DataReplicationRule;
    }

    public ModifyS3DataReplicationRuleSpectraS3Request withInitialDataPlacement(S3InitialDataPlacementPolicy initialDataPlacement) {
        this.initialDataPlacement = initialDataPlacement;
        this.updateQueryParam("initial_data_placement", initialDataPlacement);
        return this;
    }

    public ModifyS3DataReplicationRuleSpectraS3Request withMaxBlobPartSizeInBytes(long maxBlobPartSizeInBytes) {
        this.maxBlobPartSizeInBytes = maxBlobPartSizeInBytes;
        this.updateQueryParam("max_blob_part_size_in_bytes", maxBlobPartSizeInBytes);
        return this;
    }

    public ModifyS3DataReplicationRuleSpectraS3Request withReplicateDeletes(boolean replicateDeletes) {
        this.replicateDeletes = replicateDeletes;
        this.updateQueryParam("replicate_deletes", replicateDeletes);
        return this;
    }

    public ModifyS3DataReplicationRuleSpectraS3Request withType(DataReplicationRuleType type) {
        this.type = type;
        this.updateQueryParam("type", type);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/s3_data_replication_rule/" + this.s3DataReplicationRule;
    }

    public String getS3DataReplicationRule() {
        return this.s3DataReplicationRule;
    }

    public S3InitialDataPlacementPolicy getInitialDataPlacement() {
        return this.initialDataPlacement;
    }

    public long getMaxBlobPartSizeInBytes() {
        return this.maxBlobPartSizeInBytes;
    }

    public boolean getReplicateDeletes() {
        return this.replicateDeletes;
    }

    public DataReplicationRuleType getType() {
        return this.type;
    }
}

