/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.LtfsFileNamingMode;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.models.WriteOptimization;
import com.spectralogic.ds3client.networking.HttpVerb;

public class PutStorageDomainSpectraS3Request
extends AbstractRequest {
    private final String name;
    private Long autoEjectMediaFullThreshold;
    private String autoEjectUponCron;
    private boolean autoEjectUponJobCancellation;
    private boolean autoEjectUponJobCompletion;
    private boolean autoEjectUponMediaFull;
    private LtfsFileNamingMode ltfsFileNaming;
    private int maxTapeFragmentationPercent;
    private Integer maximumAutoVerificationFrequencyInDays;
    private boolean mediaEjectionAllowed;
    private boolean secureMediaAllocation;
    private Priority verifyPriorToAutoEject;
    private WriteOptimization writeOptimization;

    public PutStorageDomainSpectraS3Request(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
    }

    public PutStorageDomainSpectraS3Request withAutoEjectMediaFullThreshold(Long autoEjectMediaFullThreshold) {
        this.autoEjectMediaFullThreshold = autoEjectMediaFullThreshold;
        this.updateQueryParam("auto_eject_media_full_threshold", autoEjectMediaFullThreshold);
        return this;
    }

    public PutStorageDomainSpectraS3Request withAutoEjectUponCron(String autoEjectUponCron) {
        this.autoEjectUponCron = autoEjectUponCron;
        this.updateQueryParam("auto_eject_upon_cron", autoEjectUponCron);
        return this;
    }

    public PutStorageDomainSpectraS3Request withAutoEjectUponJobCancellation(boolean autoEjectUponJobCancellation) {
        this.autoEjectUponJobCancellation = autoEjectUponJobCancellation;
        this.updateQueryParam("auto_eject_upon_job_cancellation", autoEjectUponJobCancellation);
        return this;
    }

    public PutStorageDomainSpectraS3Request withAutoEjectUponJobCompletion(boolean autoEjectUponJobCompletion) {
        this.autoEjectUponJobCompletion = autoEjectUponJobCompletion;
        this.updateQueryParam("auto_eject_upon_job_completion", autoEjectUponJobCompletion);
        return this;
    }

    public PutStorageDomainSpectraS3Request withAutoEjectUponMediaFull(boolean autoEjectUponMediaFull) {
        this.autoEjectUponMediaFull = autoEjectUponMediaFull;
        this.updateQueryParam("auto_eject_upon_media_full", autoEjectUponMediaFull);
        return this;
    }

    public PutStorageDomainSpectraS3Request withLtfsFileNaming(LtfsFileNamingMode ltfsFileNaming) {
        this.ltfsFileNaming = ltfsFileNaming;
        this.updateQueryParam("ltfs_file_naming", ltfsFileNaming);
        return this;
    }

    public PutStorageDomainSpectraS3Request withMaxTapeFragmentationPercent(int maxTapeFragmentationPercent) {
        this.maxTapeFragmentationPercent = maxTapeFragmentationPercent;
        this.updateQueryParam("max_tape_fragmentation_percent", maxTapeFragmentationPercent);
        return this;
    }

    public PutStorageDomainSpectraS3Request withMaximumAutoVerificationFrequencyInDays(Integer maximumAutoVerificationFrequencyInDays) {
        this.maximumAutoVerificationFrequencyInDays = maximumAutoVerificationFrequencyInDays;
        this.updateQueryParam("maximum_auto_verification_frequency_in_days", maximumAutoVerificationFrequencyInDays);
        return this;
    }

    public PutStorageDomainSpectraS3Request withMediaEjectionAllowed(boolean mediaEjectionAllowed) {
        this.mediaEjectionAllowed = mediaEjectionAllowed;
        this.updateQueryParam("media_ejection_allowed", mediaEjectionAllowed);
        return this;
    }

    public PutStorageDomainSpectraS3Request withSecureMediaAllocation(boolean secureMediaAllocation) {
        this.secureMediaAllocation = secureMediaAllocation;
        this.updateQueryParam("secure_media_allocation", secureMediaAllocation);
        return this;
    }

    public PutStorageDomainSpectraS3Request withVerifyPriorToAutoEject(Priority verifyPriorToAutoEject) {
        this.verifyPriorToAutoEject = verifyPriorToAutoEject;
        this.updateQueryParam("verify_prior_to_auto_eject", verifyPriorToAutoEject);
        return this;
    }

    public PutStorageDomainSpectraS3Request withWriteOptimization(WriteOptimization writeOptimization) {
        this.writeOptimization = writeOptimization;
        this.updateQueryParam("write_optimization", writeOptimization);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/storage_domain";
    }

    public String getName() {
        return this.name;
    }

    public Long getAutoEjectMediaFullThreshold() {
        return this.autoEjectMediaFullThreshold;
    }

    public String getAutoEjectUponCron() {
        return this.autoEjectUponCron;
    }

    public boolean getAutoEjectUponJobCancellation() {
        return this.autoEjectUponJobCancellation;
    }

    public boolean getAutoEjectUponJobCompletion() {
        return this.autoEjectUponJobCompletion;
    }

    public boolean getAutoEjectUponMediaFull() {
        return this.autoEjectUponMediaFull;
    }

    public LtfsFileNamingMode getLtfsFileNaming() {
        return this.ltfsFileNaming;
    }

    public int getMaxTapeFragmentationPercent() {
        return this.maxTapeFragmentationPercent;
    }

    public Integer getMaximumAutoVerificationFrequencyInDays() {
        return this.maximumAutoVerificationFrequencyInDays;
    }

    public boolean getMediaEjectionAllowed() {
        return this.mediaEjectionAllowed;
    }

    public boolean getSecureMediaAllocation() {
        return this.secureMediaAllocation;
    }

    public Priority getVerifyPriorToAutoEject() {
        return this.verifyPriorToAutoEject;
    }

    public WriteOptimization getWriteOptimization() {
        return this.writeOptimization;
    }
}

