/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.spectralogic.ds3client.helpers.DataTransferredListener;
import com.spectralogic.ds3client.helpers.JobPartTracker;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.helpers.ObjectPart;
import com.spectralogic.ds3client.helpers.ObjectPartTracker;
import java.util.Map;

public class JobPartTrackerImpl
implements JobPartTracker {
    private final Map<String, ObjectPartTracker> trackers;

    public JobPartTrackerImpl(Map<String, ObjectPartTracker> trackers) {
        if (trackers == null) {
            throw new IllegalArgumentException("The trackers parameter cannot be null");
        }
        this.trackers = trackers;
    }

    @Override
    public void completePart(String key, ObjectPart objectPart) {
        this.trackers.get(key).completePart(objectPart);
    }

    @Override
    public boolean containsPart(String key, ObjectPart objectPart) {
        return this.trackers.get(key).containsPart(objectPart);
    }

    @Override
    public JobPartTracker attachDataTransferredListener(DataTransferredListener listener) {
        for (ObjectPartTracker tracker : this.trackers.values()) {
            tracker.attachDataTransferredListener(listener);
        }
        return this;
    }

    @Override
    public JobPartTracker attachObjectCompletedListener(ObjectCompletedListener listener) {
        for (ObjectPartTracker tracker : this.trackers.values()) {
            tracker.attachObjectCompletedListener(listener);
        }
        return this;
    }

    @Override
    public void removeDataTransferredListener(DataTransferredListener listener) {
        for (ObjectPartTracker tracker : this.trackers.values()) {
            tracker.removeDataTransferredListener(listener);
        }
    }

    @Override
    public void removeObjectCompletedListener(ObjectCompletedListener listener) {
        for (ObjectPartTracker tracker : this.trackers.values()) {
            tracker.removeObjectCompletedListener(listener);
        }
    }

    public String toString() {
        return "JobPartTrackerImpl{trackers=" + this.trackers.keySet() + '}';
    }
}

