/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.blobstrategy;

import com.google.common.base.Preconditions;
import com.spectralogic.ds3client.helpers.strategy.blobstrategy.ChunkAttemptRetryDelayBehavior;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.EventDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientDefinedChunkAttemptRetryDelayBehavior
implements ChunkAttemptRetryDelayBehavior {
    private static final Logger LOG = LoggerFactory.getLogger(ClientDefinedChunkAttemptRetryDelayBehavior.class);
    private final int clientDefinedDelayInSeconds;
    private final EventDispatcher eventDispatcher;

    public ClientDefinedChunkAttemptRetryDelayBehavior(int clientDefinedDelayInSeconds, EventDispatcher eventDispatcher) {
        Preconditions.checkState((clientDefinedDelayInSeconds >= 0 ? 1 : 0) != 0, (Object)"clientDefinedDelayInSeconds must be >= 0");
        Preconditions.checkNotNull((Object)eventDispatcher, (Object)"eventDispatcher may not be null");
        this.clientDefinedDelayInSeconds = clientDefinedDelayInSeconds;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public void delay(int delayIntervalInSeconds) throws InterruptedException {
        LOG.debug("Will retry allocate chunk call after {} seconds", (Object)this.clientDefinedDelayInSeconds);
        this.eventDispatcher.emitWaitingForChunksEvents(this.clientDefinedDelayInSeconds);
        Thread.sleep(this.clientDefinedDelayInSeconds * 1000);
    }
}

