/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.utils;

import com.google.common.escape.Escaper;
import com.google.common.net.PercentEscaper;
import com.spectralogic.ds3client.commands.interfaces.Ds3Request;
import java.util.Date;

public final class SafeStringManipulation {
    private static final String DS3_URL_PATH_FRAGMENT_SAFE_CHARS = "-._~!$'()*,&=@:/";
    private static final String DS3_QUERY_PARAM_SAFE_CHARS = "-._~!$'()*,@/";
    private static final Escaper DS3_URL_FRAGMENT_ESCAPER = new PercentEscaper("-._~!$'()*,&=@:/", false);
    private static final Escaper DS3_QUERY_PARAM_ESCAPER = new PercentEscaper("-._~!$'()*,@/", false);

    private SafeStringManipulation() {
    }

    public static <T> String safeQueryParamEscape(T obj) {
        if (obj == null) {
            return null;
        }
        return DS3_QUERY_PARAM_ESCAPER.escape(SafeStringManipulation.safeToString(obj));
    }

    public static <T> String safeUrlEscape(T obj) {
        if (obj == null) {
            return null;
        }
        return SafeStringManipulation.getDs3Escaper().escape(SafeStringManipulation.safeToString(obj));
    }

    public static <T> String safeToString(T obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass().isPrimitive()) {
            return String.valueOf(obj);
        }
        if (obj instanceof Date) {
            return Long.toString(((Date)obj).getTime());
        }
        return obj.toString();
    }

    public static Escaper getDs3Escaper() {
        return DS3_URL_FRAGMENT_ESCAPER;
    }

    public static String getEscapedRequestPath(Ds3Request request) {
        if (request == null || request.getPath() == null) {
            return "";
        }
        return SafeStringManipulation.getDs3Escaper().escape(request.getPath());
    }
}

