/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.googledrive.DriveHomeFinderService;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.DriveTeamDrivesListService;
import ch.cyberduck.core.googledrive.FileidDriveListService;
import java.util.Comparator;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class DriveFileidProvider
implements IdProvider {
    private final DriveSession session;
    private Cache<Path> cache = PathCache.empty();

    public DriveFileidProvider(DriveSession session) {
        this.session = session;
    }

    public String getFileid(Path file, ListProgressListener listener) throws BackgroundException {
        AttributedList list;
        Path found;
        if (StringUtils.isNotBlank((CharSequence)file.attributes().getFileId())) {
            return file.attributes().getFileId();
        }
        if (file.isRoot() || file.equals((Object)DriveHomeFinderService.MYDRIVE_FOLDER) || file.equals((Object)DriveHomeFinderService.SHARED_FOLDER_NAME) || file.equals((Object)DriveHomeFinderService.SHARED_DRIVES_NAME)) {
            return "root";
        }
        if (this.cache.isCached((Referenceable)file.getParent()) && null != (found = (Path)(list = this.cache.get((Referenceable)file.getParent())).filter((Comparator)new IgnoreTrashedComparator()).find((Predicate)new SimplePathPredicate(file))) && StringUtils.isNotBlank((CharSequence)file.attributes().getFileId())) {
            return this.set(file, found.attributes().getFileId());
        }
        if (DriveHomeFinderService.SHARED_DRIVES_NAME.equals((Object)file.getParent())) {
            Path found2 = (Path)new DriveTeamDrivesListService(this.session).withCache(this.cache).list(file.getParent(), listener).find((Predicate)new SimplePathPredicate(file));
            if (null == found2) {
                throw new NotfoundException(file.getAbsolute());
            }
            return this.set(file, found2.attributes().getFileId());
        }
        Path query = file.getType().contains(AbstractPath.Type.placeholder) ? new Path(file.getParent(), FilenameUtils.removeExtension((String)file.getName()), file.getType(), file.attributes()) : file;
        AttributedList<Path> list2 = new FileidDriveListService(this.session, this, query).list(file.getParent(), (ListProgressListener)new DisabledListProgressListener());
        Path found3 = (Path)list2.filter((Comparator)new IgnoreTrashedComparator()).find((Predicate)new SimplePathPredicate(file));
        if (null == found3) {
            throw new NotfoundException(file.getAbsolute());
        }
        return this.set(file, found3.attributes().getFileId());
    }

    protected String set(Path file, String id) {
        file.attributes().setFileId(id);
        return id;
    }

    public DriveFileidProvider withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    private static final class IgnoreTrashedComparator
    implements Comparator<Path> {
        private IgnoreTrashedComparator() {
        }

        @Override
        public int compare(Path o1, Path o2) {
            return Boolean.compare(o1.attributes().isDuplicate(), o2.attributes().isDuplicate());
        }
    }

    public static final class IgnoreTrashedPathPredicate
    extends SimplePathPredicate {
        public IgnoreTrashedPathPredicate(Path file) {
            super(file);
        }

        public boolean test(Path test) {
            if (test.attributes().isDuplicate()) {
                return false;
            }
            return super.test(test);
        }
    }
}

