/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.auth;

import ch.cyberduck.core.AuthenticationProvider;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.sftp.SFTPExceptionMappingService;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthNone;
import org.apache.log4j.Logger;

public class SFTPNoneAuthentication
implements AuthenticationProvider<Boolean> {
    private static final Logger log = Logger.getLogger(SFTPNoneAuthentication.class);
    private final SSHClient client;

    public SFTPNoneAuthentication(SSHClient client) {
        this.client = client;
    }

    public Boolean authenticate(Host bookmark, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Login using none authentication with credentials %s", bookmark.getCredentials()));
        }
        try {
            this.client.auth(bookmark.getCredentials().getUsername(), new AuthMethod[]{new AuthNone()});
            return this.client.isAuthenticated();
        }
        catch (IOException e) {
            throw new SFTPExceptionMappingService().map(e);
        }
    }

    public String getMethod() {
        return "none";
    }
}

