/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sftp.openssh;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.CredentialsConfigurator;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.sftp.openssh.config.transport.OpenSshConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class OpenSSHCredentialsConfigurator
implements CredentialsConfigurator {
    private static final Logger log = Logger.getLogger(OpenSSHCredentialsConfigurator.class);
    private final OpenSshConfig configuration;
    private final Preferences preferences = PreferencesFactory.get();

    public OpenSSHCredentialsConfigurator() {
        this(new OpenSshConfig(LocalFactory.get((Local)LocalFactory.get((Local)LocalFactory.get(), (String)".ssh"), (String)"config")));
    }

    public OpenSSHCredentialsConfigurator(OpenSshConfig configuration) {
        this.configuration = configuration;
    }

    public Credentials configure(Host host) {
        Credentials credentials = new Credentials(host.getCredentials());
        if (StringUtils.isNotBlank((CharSequence)host.getHostname())) {
            this.configuration.refresh();
            OpenSshConfig.Host entry = this.configuration.lookup(host.getHostname());
            if (StringUtils.isNotBlank((CharSequence)entry.getUser()) && !credentials.validate(host.getProtocol(), new LoginOptions(host.getProtocol()).password(false))) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Using username %s from %s", entry, this.configuration));
                }
                credentials.setUsername(entry.getUser());
            }
            if (!credentials.isPublicKeyAuthentication()) {
                if (null != entry.getIdentityFile()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Using identity %s from %s", entry, this.configuration));
                    }
                    credentials.setIdentity(entry.getIdentityFile());
                } else if (this.preferences.getBoolean("ssh.authentication.publickey.default.enable")) {
                    Local rsa = LocalFactory.get((String)this.preferences.getProperty("ssh.authentication.publickey.default.rsa"));
                    if (rsa.exists()) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Using RSA default host key %s from %s", rsa, this.configuration));
                        }
                        credentials.setIdentity(rsa);
                    } else {
                        Local dsa = LocalFactory.get((String)this.preferences.getProperty("ssh.authentication.publickey.default.dsa"));
                        if (dsa.exists()) {
                            if (log.isInfoEnabled()) {
                                log.info((Object)String.format("Using DSA default host key %s from %s", dsa, this.configuration));
                            }
                            credentials.setIdentity(dsa);
                        }
                    }
                }
            }
        }
        return credentials;
    }

    public CredentialsConfigurator reload() {
        this.configuration.refresh();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OpenSSHCredentialsConfigurator{");
        sb.append("configuration=").append(this.configuration);
        sb.append('}');
        return sb.toString();
    }
}

