/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

class ListSharedLinksArg {
    protected final String path;
    protected final String cursor;
    protected final Boolean directOnly;

    public ListSharedLinksArg(String path, String cursor, Boolean directOnly) {
        if (path != null && !Pattern.matches("(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        this.cursor = cursor;
        this.directOnly = directOnly;
    }

    public ListSharedLinksArg() {
        this(null, null, null);
    }

    public String getPath() {
        return this.path;
    }

    public String getCursor() {
        return this.cursor;
    }

    public Boolean getDirectOnly() {
        return this.directOnly;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.cursor, this.directOnly});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListSharedLinksArg other = (ListSharedLinksArg)obj;
            return (this.path == other.path || this.path != null && this.path.equals(other.path)) && (this.cursor == other.cursor || this.cursor != null && this.cursor.equals(other.cursor)) && (this.directOnly == other.directOnly || this.directOnly != null && this.directOnly.equals(other.directOnly));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListSharedLinksArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListSharedLinksArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.path != null) {
                g.writeFieldName("path");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.path, g);
            }
            if (value.cursor != null) {
                g.writeFieldName("cursor");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.cursor, g);
            }
            if (value.directOnly != null) {
                g.writeFieldName("direct_only");
                StoneSerializers.nullable(StoneSerializers.boolean_()).serialize(value.directOnly, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public ListSharedLinksArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_directOnly;
            String f_cursor;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_cursor = null;
                f_directOnly = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("cursor".equals(field)) {
                        f_cursor = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("direct_only".equals(field)) {
                        f_directOnly = StoneSerializers.nullable(StoneSerializers.boolean_()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListSharedLinksArg value = new ListSharedLinksArg(f_path, f_cursor, f_directOnly);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String path = null;
        protected String cursor = null;
        protected Boolean directOnly = null;

        protected Builder() {
        }

        public Builder withPath(String path) {
            if (path != null && !Pattern.matches("(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            return this;
        }

        public Builder withCursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public Builder withDirectOnly(Boolean directOnly) {
            this.directOnly = directOnly;
            return this;
        }

        public ListSharedLinksArg build() {
            return new ListSharedLinksArg(this.path, this.cursor, this.directOnly);
        }
    }
}

