/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.BaseDfbReport;
import com.dropbox.core.v2.team.StorageBucket;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class GetStorageReport
extends BaseDfbReport {
    protected final List<Long> totalUsage;
    protected final List<Long> sharedUsage;
    protected final List<Long> unsharedUsage;
    protected final List<Long> sharedFolders;
    protected final List<List<StorageBucket>> memberStorageMap;

    public GetStorageReport(String startDate, List<Long> totalUsage, List<Long> sharedUsage, List<Long> unsharedUsage, List<Long> sharedFolders, List<List<StorageBucket>> memberStorageMap) {
        super(startDate);
        if (totalUsage == null) {
            throw new IllegalArgumentException("Required value for 'totalUsage' is null");
        }
        for (Long l : totalUsage) {
            if (l != null) continue;
            throw new IllegalArgumentException("An item in list 'totalUsage' is null");
        }
        this.totalUsage = totalUsage;
        if (sharedUsage == null) {
            throw new IllegalArgumentException("Required value for 'sharedUsage' is null");
        }
        for (Long l : sharedUsage) {
            if (l != null) continue;
            throw new IllegalArgumentException("An item in list 'sharedUsage' is null");
        }
        this.sharedUsage = sharedUsage;
        if (unsharedUsage == null) {
            throw new IllegalArgumentException("Required value for 'unsharedUsage' is null");
        }
        for (Long l : unsharedUsage) {
            if (l != null) continue;
            throw new IllegalArgumentException("An item in list 'unsharedUsage' is null");
        }
        this.unsharedUsage = unsharedUsage;
        if (sharedFolders == null) {
            throw new IllegalArgumentException("Required value for 'sharedFolders' is null");
        }
        for (Long l : sharedFolders) {
            if (l != null) continue;
            throw new IllegalArgumentException("An item in list 'sharedFolders' is null");
        }
        this.sharedFolders = sharedFolders;
        if (memberStorageMap == null) {
            throw new IllegalArgumentException("Required value for 'memberStorageMap' is null");
        }
        for (List list : memberStorageMap) {
            if (list == null) {
                throw new IllegalArgumentException("An item in list 'memberStorageMap' is null");
            }
            for (StorageBucket x1 : list) {
                if (x1 != null) continue;
                throw new IllegalArgumentException("An item in listan item in list 'memberStorageMap' is null");
            }
        }
        this.memberStorageMap = memberStorageMap;
    }

    @Override
    public String getStartDate() {
        return this.startDate;
    }

    public List<Long> getTotalUsage() {
        return this.totalUsage;
    }

    public List<Long> getSharedUsage() {
        return this.sharedUsage;
    }

    public List<Long> getUnsharedUsage() {
        return this.unsharedUsage;
    }

    public List<Long> getSharedFolders() {
        return this.sharedFolders;
    }

    public List<List<StorageBucket>> getMemberStorageMap() {
        return this.memberStorageMap;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.totalUsage, this.sharedUsage, this.unsharedUsage, this.sharedFolders, this.memberStorageMap});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            GetStorageReport other = (GetStorageReport)obj;
            return !(this.startDate != other.startDate && !this.startDate.equals(other.startDate) || this.totalUsage != other.totalUsage && !this.totalUsage.equals(other.totalUsage) || this.sharedUsage != other.sharedUsage && !this.sharedUsage.equals(other.sharedUsage) || this.unsharedUsage != other.unsharedUsage && !this.unsharedUsage.equals(other.unsharedUsage) || this.sharedFolders != other.sharedFolders && !this.sharedFolders.equals(other.sharedFolders) || this.memberStorageMap != other.memberStorageMap && !this.memberStorageMap.equals(other.memberStorageMap));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<GetStorageReport> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GetStorageReport value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("start_date");
            StoneSerializers.string().serialize(value.startDate, g);
            g.writeFieldName("total_usage");
            StoneSerializers.list(StoneSerializers.nullable(StoneSerializers.uInt64())).serialize(value.totalUsage, g);
            g.writeFieldName("shared_usage");
            StoneSerializers.list(StoneSerializers.nullable(StoneSerializers.uInt64())).serialize(value.sharedUsage, g);
            g.writeFieldName("unshared_usage");
            StoneSerializers.list(StoneSerializers.nullable(StoneSerializers.uInt64())).serialize(value.unsharedUsage, g);
            g.writeFieldName("shared_folders");
            StoneSerializers.list(StoneSerializers.nullable(StoneSerializers.uInt64())).serialize(value.sharedFolders, g);
            g.writeFieldName("member_storage_map");
            StoneSerializers.list(StoneSerializers.list(StorageBucket.Serializer.INSTANCE)).serialize(value.memberStorageMap, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GetStorageReport deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<List<StorageBucket>> f_memberStorageMap;
            List<Long> f_sharedFolders;
            List<Long> f_unsharedUsage;
            List<Long> f_sharedUsage;
            List<Long> f_totalUsage;
            String f_startDate;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_startDate = null;
                f_totalUsage = null;
                f_sharedUsage = null;
                f_unsharedUsage = null;
                f_sharedFolders = null;
                f_memberStorageMap = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("start_date".equals(field)) {
                        f_startDate = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("total_usage".equals(field)) {
                        f_totalUsage = StoneSerializers.list(StoneSerializers.nullable(StoneSerializers.uInt64())).deserialize(p);
                        continue;
                    }
                    if ("shared_usage".equals(field)) {
                        f_sharedUsage = StoneSerializers.list(StoneSerializers.nullable(StoneSerializers.uInt64())).deserialize(p);
                        continue;
                    }
                    if ("unshared_usage".equals(field)) {
                        f_unsharedUsage = StoneSerializers.list(StoneSerializers.nullable(StoneSerializers.uInt64())).deserialize(p);
                        continue;
                    }
                    if ("shared_folders".equals(field)) {
                        f_sharedFolders = StoneSerializers.list(StoneSerializers.nullable(StoneSerializers.uInt64())).deserialize(p);
                        continue;
                    }
                    if ("member_storage_map".equals(field)) {
                        f_memberStorageMap = StoneSerializers.list(StoneSerializers.list(StorageBucket.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_startDate == null) {
                    throw new JsonParseException(p, "Required field \"start_date\" missing.");
                }
                if (f_totalUsage == null) {
                    throw new JsonParseException(p, "Required field \"total_usage\" missing.");
                }
                if (f_sharedUsage == null) {
                    throw new JsonParseException(p, "Required field \"shared_usage\" missing.");
                }
                if (f_unsharedUsage == null) {
                    throw new JsonParseException(p, "Required field \"unshared_usage\" missing.");
                }
                if (f_sharedFolders == null) {
                    throw new JsonParseException(p, "Required field \"shared_folders\" missing.");
                }
                if (f_memberStorageMap == null) {
                    throw new JsonParseException(p, "Required field \"member_storage_map\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            GetStorageReport value = new GetStorageReport(f_startDate, f_totalUsage, f_sharedUsage, f_unsharedUsage, f_sharedFolders, f_memberStorageMap);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

