/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

class LegalHoldsPolicyCreateArg {
    protected final String name;
    protected final String description;
    protected final List<String> members;
    protected final Date startDate;
    protected final Date endDate;

    public LegalHoldsPolicyCreateArg(String name, List<String> members, String description, Date startDate, Date endDate) {
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        if (name.length() > 140) {
            throw new IllegalArgumentException("String 'name' is longer than 140");
        }
        this.name = name;
        if (description != null && description.length() > 501) {
            throw new IllegalArgumentException("String 'description' is longer than 501");
        }
        this.description = description;
        if (members == null) {
            throw new IllegalArgumentException("Required value for 'members' is null");
        }
        for (String x : members) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'members' is null");
        }
        this.members = members;
        this.startDate = LangUtil.truncateMillis(startDate);
        this.endDate = LangUtil.truncateMillis(endDate);
    }

    public LegalHoldsPolicyCreateArg(String name, List<String> members) {
        this(name, members, null, null, null);
    }

    public String getName() {
        return this.name;
    }

    public List<String> getMembers() {
        return this.members;
    }

    public String getDescription() {
        return this.description;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public static Builder newBuilder(String name, List<String> members) {
        return new Builder(name, members);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.name, this.description, this.members, this.startDate, this.endDate});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            LegalHoldsPolicyCreateArg other = (LegalHoldsPolicyCreateArg)obj;
            return !(this.name != other.name && !this.name.equals(other.name) || this.members != other.members && !this.members.equals(other.members) || this.description != other.description && (this.description == null || !this.description.equals(other.description)) || this.startDate != other.startDate && (this.startDate == null || !this.startDate.equals(other.startDate)) || this.endDate != other.endDate && (this.endDate == null || !this.endDate.equals(other.endDate)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LegalHoldsPolicyCreateArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LegalHoldsPolicyCreateArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("members");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.members, g);
            if (value.description != null) {
                g.writeFieldName("description");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.description, g);
            }
            if (value.startDate != null) {
                g.writeFieldName("start_date");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.startDate, g);
            }
            if (value.endDate != null) {
                g.writeFieldName("end_date");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.endDate, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public LegalHoldsPolicyCreateArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_endDate;
            Date f_startDate;
            String f_description;
            List<String> f_members;
            String f_name;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_name = null;
                f_members = null;
                f_description = null;
                f_startDate = null;
                f_endDate = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("members".equals(field)) {
                        f_members = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("description".equals(field)) {
                        f_description = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("start_date".equals(field)) {
                        f_startDate = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("end_date".equals(field)) {
                        f_endDate = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_members == null) {
                    throw new JsonParseException(p, "Required field \"members\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            LegalHoldsPolicyCreateArg value = new LegalHoldsPolicyCreateArg(f_name, f_members, f_description, f_startDate, f_endDate);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String name;
        protected final List<String> members;
        protected String description;
        protected Date startDate;
        protected Date endDate;

        protected Builder(String name, List<String> members) {
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            if (name.length() > 140) {
                throw new IllegalArgumentException("String 'name' is longer than 140");
            }
            this.name = name;
            if (members == null) {
                throw new IllegalArgumentException("Required value for 'members' is null");
            }
            for (String x : members) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'members' is null");
            }
            this.members = members;
            this.description = null;
            this.startDate = null;
            this.endDate = null;
        }

        public Builder withDescription(String description) {
            if (description != null && description.length() > 501) {
                throw new IllegalArgumentException("String 'description' is longer than 501");
            }
            this.description = description;
            return this;
        }

        public Builder withStartDate(Date startDate) {
            this.startDate = LangUtil.truncateMillis(startDate);
            return this;
        }

        public Builder withEndDate(Date endDate) {
            this.endDate = LangUtil.truncateMillis(endDate);
            return this;
        }

        public LegalHoldsPolicyCreateArg build() {
            return new LegalHoldsPolicyCreateArg(this.name, this.members, this.description, this.startDate, this.endDate);
        }
    }
}

