/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class LegalHoldsActivateAHoldDetails {
    protected final String legalHoldId;
    protected final String name;
    protected final Date startDate;
    protected final Date endDate;

    public LegalHoldsActivateAHoldDetails(String legalHoldId, String name, Date startDate, Date endDate) {
        if (legalHoldId == null) {
            throw new IllegalArgumentException("Required value for 'legalHoldId' is null");
        }
        this.legalHoldId = legalHoldId;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (startDate == null) {
            throw new IllegalArgumentException("Required value for 'startDate' is null");
        }
        this.startDate = LangUtil.truncateMillis(startDate);
        this.endDate = LangUtil.truncateMillis(endDate);
    }

    public LegalHoldsActivateAHoldDetails(String legalHoldId, String name, Date startDate) {
        this(legalHoldId, name, startDate, null);
    }

    public String getLegalHoldId() {
        return this.legalHoldId;
    }

    public String getName() {
        return this.name;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.legalHoldId, this.name, this.startDate, this.endDate});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            LegalHoldsActivateAHoldDetails other = (LegalHoldsActivateAHoldDetails)obj;
            return !(this.legalHoldId != other.legalHoldId && !this.legalHoldId.equals(other.legalHoldId) || this.name != other.name && !this.name.equals(other.name) || this.startDate != other.startDate && !this.startDate.equals(other.startDate) || this.endDate != other.endDate && (this.endDate == null || !this.endDate.equals(other.endDate)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LegalHoldsActivateAHoldDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LegalHoldsActivateAHoldDetails value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("legal_hold_id");
            StoneSerializers.string().serialize(value.legalHoldId, g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("start_date");
            StoneSerializers.timestamp().serialize(value.startDate, g);
            if (value.endDate != null) {
                g.writeFieldName("end_date");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.endDate, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public LegalHoldsActivateAHoldDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Date f_endDate;
            Date f_startDate;
            String f_name;
            String f_legalHoldId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_legalHoldId = null;
                f_name = null;
                f_startDate = null;
                f_endDate = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("legal_hold_id".equals(field)) {
                        f_legalHoldId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("start_date".equals(field)) {
                        f_startDate = StoneSerializers.timestamp().deserialize(p);
                        continue;
                    }
                    if ("end_date".equals(field)) {
                        f_endDate = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_legalHoldId == null) {
                    throw new JsonParseException(p, "Required field \"legal_hold_id\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_startDate == null) {
                    throw new JsonParseException(p, "Required field \"start_date\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            LegalHoldsActivateAHoldDetails value = new LegalHoldsActivateAHoldDetails(f_legalHoldId, f_name, f_startDate, f_endDate);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

