/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.aws;

import ch.cyberduck.core.DisabledCancelCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.Resolver;
import ch.cyberduck.core.exception.ResolveCanceledException;
import ch.cyberduck.core.exception.ResolveFailedException;
import ch.cyberduck.core.http.DisabledX509HostnameVerifier;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.proxy.ProxyHostUrlProvider;
import ch.cyberduck.core.proxy.ProxySocketFactory;
import ch.cyberduck.core.ssl.CustomTrustSSLProtocolSocketFactory;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.DnsResolver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpHost;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.protocol.HttpContext;

public class CustomClientConfiguration
extends ClientConfiguration {
    public CustomClientConfiguration(final Host host, final ThreadLocalHostnameDelegatingTrustManager trust, X509KeyManager key) {
        this.setDnsResolver(new DnsResolver(){

            public InetAddress[] resolve(String host) throws UnknownHostException {
                try {
                    return new InetAddress[]{new Resolver().resolve(host, (CancelCallback)new DisabledCancelCallback())};
                }
                catch (ResolveCanceledException | ResolveFailedException e) {
                    throw new UnknownHostException(e.getDetail(false));
                }
            }
        });
        int timeout = PreferencesFactory.get().getInteger("connection.timeout.seconds") * 1000;
        this.setConnectionTimeout(timeout);
        this.setSocketTimeout(timeout);
        PreferencesUseragentProvider ua = new PreferencesUseragentProvider();
        this.setUserAgentPrefix(ua.get());
        this.setUserAgentSuffix("");
        this.setMaxErrorRetry(0);
        this.setMaxConnections(1);
        this.setUseGzip(PreferencesFactory.get().getBoolean("http.compression.enable"));
        Proxy proxy = ProxyFactory.get().find(new ProxyHostUrlProvider().get(host));
        switch (proxy.getType()) {
            case HTTP: 
            case HTTPS: {
                this.setProxyHost(proxy.getHostname());
                this.setProxyPort(proxy.getPort());
            }
        }
        this.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory((SSLSocketFactory)new CustomTrustSSLProtocolSocketFactory((X509TrustManager)trust, key), (HostnameVerifier)new DisabledX509HostnameVerifier()){

            public Socket createSocket(HttpContext context) throws IOException {
                return new ProxySocketFactory(host).disable(Proxy.Type.HTTP).disable(Proxy.Type.HTTPS).createSocket();
            }

            public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
                trust.setTarget(target);
                return super.createLayeredSocket(socket, target, port, context);
            }

            public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host2, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
                trust.setTarget(host2.getHostName());
                return super.connectSocket(connectTimeout, socket, host2, remoteAddress, localAddress, context);
            }
        });
    }
}

