/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cloudfront;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.cdn.Distribution;
import ch.cyberduck.core.cdn.features.Cname;
import ch.cyberduck.core.cdn.features.Index;
import ch.cyberduck.core.cloudfront.CloudFrontDistributionConfiguration;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3BucketListService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import com.amazonaws.services.cloudfront.model.OriginProtocolPolicy;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.S3WebsiteConfig;
import org.jets3t.service.utils.ServiceUtils;

public class WebsiteCloudFrontDistributionConfiguration
extends CloudFrontDistributionConfiguration {
    public WebsiteCloudFrontDistributionConfiguration(S3Session session, X509TrustManager trust, X509KeyManager key, Map<Path, Distribution> distributions) {
        super(session, trust, key, distributions);
    }

    @Override
    public List<Distribution.Method> getMethods(Path container) {
        if (!ServiceUtils.isBucketNameValidDNSName((String)container.getName())) {
            return super.getMethods(container);
        }
        ArrayList<Distribution.Method> methods = new ArrayList<Distribution.Method>();
        if (S3Session.isAwsHostname(this.session.getHost().getHostname())) {
            methods.addAll(super.getMethods(container));
            methods.addAll(Arrays.asList(Distribution.WEBSITE, Distribution.WEBSITE_CDN));
        } else {
            methods.add(Distribution.WEBSITE);
        }
        return methods;
    }

    @Override
    public String getName(Distribution.Method method) {
        if (method.equals(Distribution.WEBSITE)) {
            return method.toString();
        }
        return super.getName(method);
    }

    @Override
    protected URI getOrigin(Path container, Distribution.Method method) {
        if (method.equals(Distribution.WEBSITE_CDN)) {
            return URI.create(String.format("http://%s", this.getWebsiteHostname(container)));
        }
        return super.getOrigin(container, method);
    }

    @Override
    public Distribution read(Path container, Distribution.Method method, LoginCallback prompt) throws BackgroundException {
        if (method.equals(Distribution.WEBSITE)) {
            try {
                S3WebsiteConfig configuration = ((RequestEntityRestStorageService)((Object)this.session.getClient())).getWebsiteConfig(container.getName());
                Distribution distribution = new Distribution(this.getOrigin(container, method), method, configuration.isWebsiteConfigActive());
                distribution.setStatus(LocaleFactory.localizedString((String)"Deployed", (String)"S3"));
                distribution.setUrl(URI.create(String.format("%s://%s", method.getScheme(), this.getWebsiteHostname(container))));
                distribution.setIndexDocument(configuration.getIndexDocumentSuffix());
                distribution.setContainers(new S3BucketListService(this.session, new S3LocationFeature.S3Region(this.session.getHost().getRegion())).list(new Path(String.valueOf('/'), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory)), (ListProgressListener)new DisabledListProgressListener()).toList());
                return distribution;
            }
            catch (ServiceException e) {
                Distribution distribution = new Distribution(this.getOrigin(container, method), method, false);
                distribution.setStatus(e.getErrorMessage());
                distribution.setUrl(URI.create(String.format("%s://%s", method.getScheme(), this.getWebsiteHostname(container))));
                return distribution;
            }
        }
        return super.read(container, method, prompt);
    }

    @Override
    public void write(Path container, Distribution distribution, LoginCallback prompt) throws BackgroundException {
        if (distribution.getMethod().equals(Distribution.WEBSITE)) {
            try {
                if (distribution.isEnabled()) {
                    String suffix = "index.html";
                    if (StringUtils.isNotBlank((CharSequence)distribution.getIndexDocument())) {
                        suffix = PathNormalizer.name((String)distribution.getIndexDocument());
                    }
                    ((RequestEntityRestStorageService)((Object)this.session.getClient())).setWebsiteConfig(container.getName(), new S3WebsiteConfig(suffix));
                }
                ((RequestEntityRestStorageService)((Object)this.session.getClient())).deleteWebsiteConfig(container.getName());
            }
            catch (S3ServiceException e) {
                throw new S3ExceptionMappingService().map("Cannot write website configuration", e);
            }
        } else {
            super.write(container, distribution, prompt);
        }
    }

    @Override
    protected OriginProtocolPolicy getPolicy(Distribution.Method method) {
        if (method.equals(Distribution.WEBSITE_CDN)) {
            return OriginProtocolPolicy.HttpOnly;
        }
        return super.getPolicy(method);
    }

    @Override
    public <T> T getFeature(Class<T> type, Distribution.Method method) {
        if (type == Index.class && method.equals(Distribution.WEBSITE)) {
            return (T)this;
        }
        if (type == Cname.class) {
            return (T)this;
        }
        return super.getFeature(type, method);
    }

    protected String getWebsiteHostname(Path bucket) {
        String location = bucket.attributes().getRegion();
        String endpoint = null == location ? "s3-website-us-east-1.amazonaws.com" : ("US".equals(location) ? "s3-website-us-east-1.amazonaws.com" : ("EU".equals(location) ? "s3-website-eu-west-1.amazonaws.com" : String.format("s3-website-%s.amazonaws.com", location)));
        return String.format("%s.%s", bucket.getName(), endpoint);
    }
}

