/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3AccessControlListFeature;
import ch.cyberduck.core.s3.S3CopyFeature;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.threading.ThreadPool;
import ch.cyberduck.core.threading.ThreadPoolFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.model.MultipartCompleted;
import org.jets3t.service.model.MultipartPart;
import org.jets3t.service.model.MultipartUpload;
import org.jets3t.service.model.S3Object;

public class S3MultipartCopyFeature
extends S3CopyFeature {
    private static final Logger log = Logger.getLogger(S3MultipartCopyFeature.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();
    private final ThreadPool pool = ThreadPoolFactory.get((String)"multipart", (int)PreferencesFactory.get().getInteger("s3.upload.multipart.concurrency"));
    private final Long partsize = PreferencesFactory.get().getLong("s3.copy.multipart.size");

    public S3MultipartCopyFeature(S3Session session) {
        this(session, new S3AccessControlListFeature(session));
    }

    public S3MultipartCopyFeature(S3Session session, S3AccessControlListFeature acl) {
        super(session, acl);
        this.session = session;
    }

    @Override
    protected String copy(Path source, S3Object destination, TransferStatus status) throws BackgroundException {
        try {
            long size;
            ArrayList<MultipartPart> completed = new ArrayList<MultipartPart>();
            MultipartUpload multipart = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartStartUpload(destination.getBucketName(), destination);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Multipart upload started for %s with ID %s", multipart.getObjectKey(), multipart.getUploadId()));
            }
            long remaining = size = status.getLength();
            long offset = 0L;
            ArrayList<Future<MultipartPart>> parts = new ArrayList<Future<MultipartPart>>();
            int partNumber = 1;
            while (remaining > 0L) {
                Long string = Math.min(Math.max(size / 10000L, this.partsize), remaining);
                parts.add(this.submit(source, multipart, partNumber, offset, string));
                remaining -= string.longValue();
                offset += string.longValue();
                ++partNumber;
            }
            for (Future future : parts) {
                try {
                    completed.add((MultipartPart)future.get());
                }
                catch (InterruptedException e) {
                    log.error((Object)"Part upload failed with interrupt failure");
                    throw new ConnectionCanceledException((Throwable)e);
                }
                catch (ExecutionException e) {
                    log.warn((Object)String.format("Part upload failed with execution failure %s", e.getMessage()));
                    if (e.getCause() instanceof BackgroundException) {
                        throw (BackgroundException)e.getCause();
                    }
                    throw new BackgroundException(e.getCause());
                }
            }
            MultipartCompleted complete = ((RequestEntityRestStorageService)((Object)this.session.getClient())).multipartCompleteUpload(multipart, completed);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Completed multipart upload for %s with checksum %s", complete.getObjectKey(), complete.getEtag()));
            }
            String string = complete.getVersionId();
            return string;
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Cannot copy {0}", e, source);
        }
        finally {
            this.pool.shutdown(false);
        }
    }

    private Future<MultipartPart> submit(final Path source, final MultipartUpload multipart, final int partNumber, final long offset, final long length) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Submit part %d of %s to queue with offset %d and length %d", partNumber, source, offset, length));
        }
        return this.pool.execute((Callable)new Callable<MultipartPart>(){

            @Override
            public MultipartPart call() throws BackgroundException {
                try {
                    HttpRange range = HttpRange.byLength((long)offset, (long)length);
                    MultipartPart part = ((RequestEntityRestStorageService)((Object)S3MultipartCopyFeature.this.session.getClient())).multipartUploadPartCopy(multipart, partNumber, S3MultipartCopyFeature.this.containerService.getContainer(source).getName(), S3MultipartCopyFeature.this.containerService.getKey(source), null, null, null, null, range.getStart(), range.getEnd(), source.attributes().getVersionId());
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Received response %s for part number %d", part, partNumber));
                    }
                    return new MultipartPart(Integer.valueOf(partNumber), null == part.getLastModified() ? new Date(System.currentTimeMillis()) : part.getLastModified(), null == part.getEtag() ? "" : part.getEtag(), part.getSize());
                }
                catch (S3ServiceException e) {
                    throw new S3ExceptionMappingService().map("Cannot copy {0}", e, source);
                }
            }
        });
    }
}

