/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.random.RandomNonceGenerator;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.random.NonceGenerator;
import ch.cyberduck.core.shared.DefaultCopyFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import org.cryptomator.cryptolib.api.FileHeader;

public class CryptoCopyFeature
implements Copy {
    private final Session<?> session;
    private final Copy proxy;
    private final CryptoVault vault;
    private Session<?> target;

    public CryptoCopyFeature(Session<?> session, Copy proxy, CryptoVault vault) {
        this.session = session;
        this.target = session;
        this.proxy = proxy;
        this.vault = vault;
    }

    public Path copy(Path source, Path copy, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        if (this.vault.contains(copy)) {
            FileHeader header = this.vault.getFileHeaderCryptor().create();
            status.setHeader(this.vault.getFileHeaderCryptor().encryptHeader(header));
            status.setNonces((NonceGenerator)new RandomNonceGenerator());
        }
        if (this.vault.contains(source) && this.vault.contains(copy)) {
            return this.vault.decrypt(this.session, this.proxy.withTarget(this.target).copy(this.vault.contains(source) ? this.vault.encrypt(this.session, source) : source, this.vault.contains(copy) ? this.vault.encrypt(this.session, copy) : copy, status, callback));
        }
        Path target = new DefaultCopyFeature(this.session).withTarget(this.target).copy(this.vault.contains(source) ? this.vault.encrypt(this.session, source) : source, this.vault.contains(copy) ? this.vault.encrypt(this.session, copy) : copy, status, callback);
        if (this.vault.contains(copy)) {
            return this.vault.decrypt(this.session, target);
        }
        return target;
    }

    public boolean isRecursive(Path source, Path copy) {
        return false;
    }

    public boolean isSupported(Path source, Path copy) {
        if (this.vault.contains(source) && this.vault.contains(copy)) {
            return this.proxy.withTarget(this.target).isSupported(source, copy);
        }
        return new DefaultCopyFeature(this.session).withTarget(this.target).isSupported(source, copy);
    }

    public Copy withTarget(Session<?> session) {
        this.target = session;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoCopyFeature{");
        sb.append("delegate=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

