/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import javax.net.ssl.SSLSocket;
import org.irods.jargon.core.connection.AbstractConnection;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.AuthMechanism;
import org.irods.jargon.core.connection.AuthScheme;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSBasicTCPConnection;
import org.irods.jargon.core.connection.IRODSMidLevelProtocol;
import org.irods.jargon.core.connection.StartupResponseData;
import org.irods.jargon.core.connection.auth.AuthResponse;
import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AuthReqPluginRequestInp;
import org.irods.jargon.core.packinstr.PamAuthRequestInp;
import org.irods.jargon.core.packinstr.Tag;

public class PAMAuth
extends AuthMechanism {
    private boolean needToWrapWithSsl = false;

    @Override
    protected AbstractIRODSMidLevelProtocol processAuthenticationAfterStartup(IRODSAccount irodsAccount, AbstractIRODSMidLevelProtocol irodsMidLevelProtocol, StartupResponseData startupResponseData) throws AuthenticationException, JargonException {
        this.needToWrapWithSsl = irodsMidLevelProtocol.getIrodsConnection().getEncryptionType() == AbstractConnection.EncryptionType.NONE;
        AbstractIRODSMidLevelProtocol irodsMidLevelProtocolToUse = null;
        if (this.needToWrapWithSsl) {
            log.info("will wrap commands with ssl");
            irodsMidLevelProtocolToUse = this.establishSecureConnectionForPamAuth(irodsAccount, irodsMidLevelProtocol);
        } else {
            log.info("no need to SSL tunnel for PAM");
            irodsMidLevelProtocolToUse = irodsMidLevelProtocol;
        }
        int pamTimeToLive = irodsMidLevelProtocolToUse.getIrodsSession().getJargonProperties().getPAMTimeToLive();
        Tag response = null;
        if (startupResponseData.checkIs410OrLater()) {
            log.info("using eirods pluggable pam auth request");
            AuthReqPluginRequestInp pi = AuthReqPluginRequestInp.instancePam(irodsAccount.getProxyName(), irodsAccount.getPassword(), pamTimeToLive);
            response = irodsMidLevelProtocolToUse.irodsFunction(pi);
        } else {
            log.info("using normal irods pam auth request");
            PamAuthRequestInp pamAuthRequestInp = PamAuthRequestInp.instance(irodsAccount.getProxyName(), irodsAccount.getPassword(), pamTimeToLive);
            response = irodsMidLevelProtocolToUse.irodsFunction(pamAuthRequestInp);
        }
        if (response == null) {
            throw new JargonException("null response from pamAuthRequest");
        }
        String tempPasswordForPam = startupResponseData.checkIs410OrLater() ? response.getTag("result_").getStringValue() : response.getTag("irodsPamPassword").getStringValue();
        if (tempPasswordForPam == null || tempPasswordForPam.isEmpty()) {
            throw new AuthenticationException("unable to retrieve the temp password resulting from the pam auth response");
        }
        log.info("have the temporary password to use to log in via pam\nsending sslEnd...");
        this.shutdownSslAndCloseConnection(irodsMidLevelProtocolToUse);
        AuthResponse authResponse = new AuthResponse();
        IRODSAccount irodsAccountUsingTemporaryIRODSPassword = new IRODSAccount(irodsAccount.getHost(), irodsAccount.getPort(), irodsAccount.getUserName(), tempPasswordForPam, irodsAccount.getHomeDirectory(), irodsAccount.getZone(), irodsAccount.getDefaultStorageResource());
        irodsAccountUsingTemporaryIRODSPassword.setAuthenticationScheme(AuthScheme.STANDARD);
        log.info("derived and logging in with temporary password from a new agent:{}", (Object)irodsAccountUsingTemporaryIRODSPassword);
        authResponse.setAuthenticatingIRODSAccount(irodsAccount);
        authResponse.setAuthenticatedIRODSAccount(irodsAccountUsingTemporaryIRODSPassword);
        authResponse.setStartupResponse(startupResponseData);
        authResponse.setSuccessful(true);
        irodsMidLevelProtocolToUse.setAuthResponse(authResponse);
        return irodsMidLevelProtocolToUse;
    }

    private void shutdownSslAndCloseConnection(AbstractIRODSMidLevelProtocol irodsCommandsToUse) throws JargonException {
        irodsCommandsToUse.shutdown();
    }

    private AbstractIRODSMidLevelProtocol establishSecureConnectionForPamAuth(IRODSAccount irodsAccount, AbstractIRODSMidLevelProtocol irodsCommands) throws JargonException, AssertionError {
        if (irodsCommands.getIrodsConnection().getEncryptionType() == AbstractConnection.EncryptionType.SSL_WRAPPED) {
            log.info("already ssl enabled");
            return irodsCommands;
        }
        log.info("not ssl wrapped, use an SSL connection for the pam auth");
        SSLSocket sslSocket = irodsCommands.getIrodsSession().instanceSslConnectionUtilities().createSslSocketForProtocol(irodsAccount, irodsCommands, true);
        log.info("creating secure protcol connection layer");
        IRODSBasicTCPConnection secureConnection = new IRODSBasicTCPConnection(irodsAccount, irodsCommands.getPipelineConfiguration(), irodsCommands.getIrodsProtocolManager(), sslSocket, irodsCommands.getIrodsSession());
        IRODSMidLevelProtocol secureIRODSCommands = new IRODSMidLevelProtocol(secureConnection, irodsCommands.getIrodsProtocolManager());
        secureIRODSCommands.setIrodsConnectionNonEncryptedRef(irodsCommands.getIrodsConnection());
        log.info("carrying over startup pack with server info");
        secureIRODSCommands.setStartupResponseData(irodsCommands.getStartupResponseData());
        log.debug("created secureIRODSCommands wrapped around an SSL socket\nSending PamAuthRequest...");
        return secureIRODSCommands;
    }

    @Override
    protected AbstractIRODSMidLevelProtocol processAfterAuthentication(AbstractIRODSMidLevelProtocol irodsMidLevelProtocol, StartupResponseData startupResponseData) throws AuthenticationException, JargonException {
        AuthResponse originalAuthResponse = irodsMidLevelProtocol.getAuthResponse();
        AbstractIRODSMidLevelProtocol actualProtocol = irodsMidLevelProtocol.getIrodsProtocolManager().getIrodsMidLevelProtocolFactory().instance(irodsMidLevelProtocol.getIrodsSession(), irodsMidLevelProtocol.getAuthResponse().getAuthenticatedIRODSAccount(), irodsMidLevelProtocol.getIrodsProtocolManager());
        actualProtocol.setAuthResponse(originalAuthResponse);
        return actualProtocol;
    }
}

