/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.util.List;
import org.irods.jargon.core.exception.DataNotFoundException;
import org.irods.jargon.core.exception.FileNotFoundException;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.JargonFileOrCollAlreadyExistsException;
import org.irods.jargon.core.exception.NoResourceDefinedException;
import org.irods.jargon.core.packinstr.DataObjInp;
import org.irods.jargon.core.pub.IRODSAccessObject;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.pub.io.IRODSFile;
import org.irods.jargon.core.query.CollectionAndDataObjectListingEntry;

public interface IRODSFileSystemAO
extends IRODSAccessObject {
    public boolean isFileReadable(IRODSFile var1) throws JargonException;

    public boolean isFileWriteable(IRODSFile var1) throws FileNotFoundException, JargonException;

    public boolean isFileExists(IRODSFile var1) throws JargonException;

    public boolean isDirectory(IRODSFile var1) throws JargonException;

    public List<String> getListInDir(IRODSFile var1) throws FileNotFoundException, JargonException;

    public List<String> getListInDirWithFilter(IRODSFile var1, FilenameFilter var2) throws JargonException, DataNotFoundException;

    public List<File> getListInDirWithFileFilter(IRODSFile var1, FileFilter var2) throws JargonException, DataNotFoundException;

    public CollectionAndDataObjectListingEntry.ObjectType getFileDataType(IRODSFile var1) throws FileNotFoundException, JargonException;

    public int createFile(String var1, DataObjInp.OpenFlags var2, int var3) throws JargonFileOrCollAlreadyExistsException, NoResourceDefinedException, JargonException;

    public int createFileInResource(String var1, DataObjInp.OpenFlags var2, int var3, String var4) throws JargonException, JargonFileOrCollAlreadyExistsException;

    public void mkdir(IRODSFile var1, boolean var2) throws JargonException;

    public void directoryDeleteForce(IRODSFile var1) throws JargonException;

    public void fileDeleteForce(IRODSFile var1) throws JargonException;

    public void renameFile(IRODSFile var1, IRODSFile var2) throws JargonException;

    public void renameDirectory(IRODSFile var1, IRODSFile var2) throws JargonException;

    public void physicalMove(IRODSFile var1, String var2) throws JargonException;

    public String getResourceNameForFile(IRODSFile var1) throws JargonException;

    public int openFile(IRODSFile var1, DataObjInp.OpenFlags var2) throws JargonException;

    public void physicalMove(String var1, String var2) throws JargonException;

    public void directoryDeleteNoForce(IRODSFile var1) throws JargonException;

    public void fileDeleteNoForce(IRODSFile var1) throws JargonException;

    public int getDirectoryPermissions(IRODSFile var1) throws JargonException;

    public int getFilePermissions(IRODSFile var1) throws JargonException;

    public int getDirectoryPermissionsForGivenUser(IRODSFile var1, String var2) throws FileNotFoundException, JargonException;

    public int getFilePermissionsForGivenUser(IRODSFile var1, String var2) throws JargonException;

    public boolean isFileExecutable(IRODSFile var1) throws JargonException;

    public boolean isFile(IRODSFile var1) throws JargonException;

    public ObjStat getObjStat(String var1) throws FileNotFoundException, JargonException;

    public void fileClose(int var1, boolean var2) throws JargonException;
}

