/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.pub.io;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.aohelper.AOHelper;
import org.irods.jargon.core.pub.aohelper.CollectionAOHelper;
import org.irods.jargon.core.query.GenQueryBuilderException;
import org.irods.jargon.core.query.IRODSGenQueryBuilder;
import org.irods.jargon.core.query.QueryConditionOperators;
import org.irods.jargon.core.query.RodsGenQueryEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IRODSFileSystemAOHelper
extends AOHelper {
    static Logger log = LoggerFactory.getLogger(IRODSFileSystemAOHelper.class);

    public static void buildQueryListAllCollections(String path, IRODSGenQueryBuilder builder) throws GenQueryBuilderException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("null or empty path");
        }
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        CollectionAOHelper.buildSelectsNeededForCollectionsInCollectionsAndDataObjectsListingEntry(builder);
        builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_PARENT_NAME, QueryConditionOperators.EQUAL, path);
    }

    public static void buildQueryListAllDataObjectsWithSizeAndDateInfo(String path, IRODSGenQueryBuilder builder) throws JargonException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("null or empty path");
        }
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        try {
            IRODSFileSystemAOHelper.buildDataObjectQuerySelects(builder);
        }
        catch (GenQueryBuilderException e) {
            throw new JargonException("exception building query", e);
        }
        builder.addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, path);
    }

    public static void buildQueryListAllDataObjectsWithUserAccessInfo(String path, IRODSGenQueryBuilder builder) throws JargonException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("null or empty path");
        }
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        try {
            IRODSFileSystemAOHelper.buildDataObjectQuerySelects(builder);
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_ACCESS_USER_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_ACCESS_TYPE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_TYPE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_USER_ZONE).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, path);
        }
        catch (GenQueryBuilderException e) {
            throw new JargonException("query exception", e);
        }
    }

    public static void buildDataObjectQuerySelects(IRODSGenQueryBuilder builder) throws GenQueryBuilderException {
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_CREATE_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_MODIFY_TIME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_DATA_ID).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_SIZE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_REPL_NUM).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_OWNER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_D_OWNER_ZONE);
    }

    public static void buildQueryListAllFiles(String path, IRODSGenQueryBuilder builder) throws JargonException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("null or empty path");
        }
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        try {
            builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_DATA_NAME).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_NAME, QueryConditionOperators.EQUAL, path);
        }
        catch (GenQueryBuilderException e) {
            throw new JargonException(e);
        }
    }

    public static void buildQueryListAllDirsWithUserAccessInfo(String path, IRODSGenQueryBuilder builder) throws GenQueryBuilderException {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("null or empty path");
        }
        if (builder == null) {
            throw new IllegalArgumentException("null builder");
        }
        CollectionAOHelper.buildSelectsNeededForCollectionsInCollectionsAndDataObjectsListingEntry(builder);
        builder.addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_ACCESS_USER_NAME).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_ACCESS_USER_ZONE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_ACCESS_TYPE).addSelectAsGenQueryValue(RodsGenQueryEnum.COL_COLL_ACCESS_USER_ID).addConditionAsGenQueryField(RodsGenQueryEnum.COL_COLL_PARENT_NAME, QueryConditionOperators.EQUAL, path);
    }
}

