/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import org.irods.jargon.core.query.GenQueryField;
import org.irods.jargon.core.query.JargonQueryException;
import org.irods.jargon.core.query.RodsGenQueryEnum;

public class TranslatedGenQueryCondition {
    private final String columnName;
    private final GenQueryField.SelectFieldSource fieldSource;
    private final String columnNumericTranslation;
    private final String operator;
    private final String value;

    public static TranslatedGenQueryCondition instance(RodsGenQueryEnum fieldName, String operator, String value) throws JargonQueryException {
        return new TranslatedGenQueryCondition(fieldName, operator, value);
    }

    public static TranslatedGenQueryCondition instanceForExtensibleMetaData(String fieldName, String operator, String value, String columnNumericTranslation) throws JargonQueryException {
        return new TranslatedGenQueryCondition(fieldName, operator, value, columnNumericTranslation);
    }

    public static TranslatedGenQueryCondition instanceWithFieldNameAndNumericTranslation(String fieldName, String operator, String value, String columnNumericTranslation) throws JargonQueryException {
        return new TranslatedGenQueryCondition(fieldName, operator, value, columnNumericTranslation);
    }

    private TranslatedGenQueryCondition(String fieldName, String operator, String value, String columnNumericTranslation) throws JargonQueryException {
        if (fieldName == null || fieldName.isEmpty()) {
            throw new JargonQueryException("field name in condition is null or blank");
        }
        if (operator == null) {
            throw new JargonQueryException("operator is null");
        }
        if (value == null) {
            throw new JargonQueryException("value in condition is null");
        }
        if (columnNumericTranslation == null || columnNumericTranslation.isEmpty()) {
            throw new JargonQueryException("columnNumericTranslation is null or blank");
        }
        this.columnName = fieldName;
        this.fieldSource = GenQueryField.SelectFieldSource.EXTENSIBLE_METADATA;
        this.operator = operator;
        this.value = value;
        this.columnNumericTranslation = columnNumericTranslation;
    }

    private TranslatedGenQueryCondition(RodsGenQueryEnum fieldName, String operator, String value) throws JargonQueryException {
        if (fieldName == null) {
            throw new JargonQueryException("field name in condition is null");
        }
        if (operator == null) {
            throw new JargonQueryException("operator is null");
        }
        if (value == null) {
            throw new JargonQueryException("value in condition is null");
        }
        this.columnName = fieldName.getName();
        this.fieldSource = GenQueryField.SelectFieldSource.DEFINED_QUERY_FIELD;
        this.operator = operator;
        this.value = value;
        this.columnNumericTranslation = String.valueOf(fieldName.getNumericValue());
    }

    private TranslatedGenQueryCondition(String fieldName, GenQueryField.SelectFieldSource fieldSource, String columnNumericTranslation, String operator, String value) throws JargonQueryException {
        if (fieldName == null || fieldName.length() == 0) {
            throw new JargonQueryException("field name in condition is blank or null");
        }
        if (fieldSource == null) {
            throw new JargonQueryException("field source in condition is null");
        }
        if (columnNumericTranslation == null || columnNumericTranslation.length() == 0) {
            throw new JargonQueryException("field source in condition is blank or null");
        }
        if (operator == null) {
            throw new JargonQueryException("operator is null");
        }
        if (value == null) {
            throw new JargonQueryException("value in condition is null");
        }
        this.columnName = fieldName;
        this.fieldSource = GenQueryField.SelectFieldSource.DEFINED_QUERY_FIELD;
        this.operator = operator;
        this.value = value;
        this.columnNumericTranslation = columnNumericTranslation;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String tabOver = "    ";
        char cr = '\n';
        b.append("translated query element:");
        b.append(cr);
        b.append(tabOver);
        b.append("columnName:");
        b.append(this.columnName);
        b.append(cr);
        b.append(tabOver);
        b.append("fieldSource:");
        b.append((Object)this.fieldSource);
        b.append(cr);
        b.append(tabOver);
        b.append("fieldTranslation:");
        b.append(this.columnNumericTranslation);
        b.append(cr);
        b.append(tabOver);
        b.append("Operator:");
        b.append(this.operator);
        b.append(cr);
        b.append(tabOver);
        b.append("Value:");
        b.append(this.value);
        return b.toString();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public GenQueryField.SelectFieldSource getFieldSource() {
        return this.fieldSource;
    }

    public String getColumnNumericTranslation() {
        return this.columnNumericTranslation;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }
}

