/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.query;

import java.util.ArrayList;
import java.util.List;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.query.AbstractIRODSGenQuery;
import org.irods.jargon.core.query.GenQueryOrderByField;
import org.irods.jargon.core.query.GenQuerySelectField;
import org.irods.jargon.core.query.TranslatedGenQueryCondition;

public class TranslatedIRODSGenQuery {
    private final List<GenQuerySelectField> selectFields;
    private final List<TranslatedGenQueryCondition> translatedQueryConditions;
    private final List<GenQueryOrderByField> orderByFields;
    private final AbstractIRODSGenQuery irodsQuery;
    private final boolean distinct;
    private final boolean upperCase;
    private final boolean computeTotalRowCount;

    public static TranslatedIRODSGenQuery instance(List<GenQuerySelectField> translatedSelectFields, List<TranslatedGenQueryCondition> translatedQueryConditions, AbstractIRODSGenQuery irodsQuery, boolean distinct, boolean upperCase) throws JargonException {
        return new TranslatedIRODSGenQuery(translatedSelectFields, translatedQueryConditions, null, irodsQuery, distinct, upperCase, false);
    }

    public static TranslatedIRODSGenQuery instance(List<GenQuerySelectField> translatedSelectFields, List<TranslatedGenQueryCondition> translatedQueryConditions, AbstractIRODSGenQuery irodsQuery, boolean distinct) throws JargonException {
        return new TranslatedIRODSGenQuery(translatedSelectFields, translatedQueryConditions, null, irodsQuery, distinct, false, false);
    }

    public static TranslatedIRODSGenQuery instance(List<GenQuerySelectField> translatedSelectFields, List<TranslatedGenQueryCondition> translatedQueryConditions, List<GenQueryOrderByField> orderByFields, AbstractIRODSGenQuery irodsQuery, boolean distinct, boolean caseInsensitive) throws JargonException {
        return new TranslatedIRODSGenQuery(translatedSelectFields, translatedQueryConditions, orderByFields, irodsQuery, distinct, caseInsensitive, false);
    }

    public static TranslatedIRODSGenQuery instance(List<GenQuerySelectField> translatedSelectFields, List<TranslatedGenQueryCondition> translatedQueryConditions, List<GenQueryOrderByField> orderByFields, AbstractIRODSGenQuery irodsQuery, boolean distinct, boolean caseInsensitive, boolean computeTotalRowCount) throws JargonException {
        return new TranslatedIRODSGenQuery(translatedSelectFields, translatedQueryConditions, orderByFields, irodsQuery, distinct, caseInsensitive, computeTotalRowCount);
    }

    public static TranslatedIRODSGenQuery instance(List<GenQuerySelectField> translatedSelectFields, List<TranslatedGenQueryCondition> translatedQueryConditions, AbstractIRODSGenQuery irodsQuery) throws JargonException {
        return new TranslatedIRODSGenQuery(translatedSelectFields, translatedQueryConditions, null, irodsQuery, true, false, false);
    }

    private TranslatedIRODSGenQuery(List<GenQuerySelectField> selectFields, List<TranslatedGenQueryCondition> translatedQueryConditions, List<GenQueryOrderByField> orderByFields, AbstractIRODSGenQuery irodsQuery, boolean distinct, boolean upperCase, boolean computeTotalRowCount) throws JargonException {
        if (translatedQueryConditions == null) {
            throw new JargonException("conditions are null");
        }
        if (selectFields == null) {
            throw new JargonException("no select column names");
        }
        this.orderByFields = orderByFields == null ? new ArrayList<GenQueryOrderByField>() : orderByFields;
        if (selectFields.isEmpty()) {
            throw new JargonException("no select column names");
        }
        if (irodsQuery == null) {
            throw new JargonException("irodsQuery is null");
        }
        this.translatedQueryConditions = translatedQueryConditions;
        this.selectFields = selectFields;
        this.irodsQuery = irodsQuery;
        this.distinct = distinct;
        this.upperCase = upperCase;
        this.computeTotalRowCount = computeTotalRowCount;
    }

    public List<GenQuerySelectField> getSelectFields() {
        return this.selectFields;
    }

    public List<TranslatedGenQueryCondition> getTranslatedQueryConditions() {
        return this.translatedQueryConditions;
    }

    public AbstractIRODSGenQuery getIrodsQuery() {
        return this.irodsQuery;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("translatedIRODSQuery:");
        sb.append("\n   selectFields:");
        sb.append(this.selectFields);
        sb.append("\n   translatedQueryConditions:");
        sb.append(this.translatedQueryConditions);
        sb.append("\n   orderByFields:");
        sb.append(this.orderByFields);
        sb.append("\n   irodsQuery:");
        sb.append(this.irodsQuery);
        sb.append("\n   distinct:");
        sb.append(this.distinct);
        sb.append("\n   upperCase:");
        sb.append(this.upperCase);
        sb.append("\n   computeTotalRowCount:");
        sb.append(this.computeTotalRowCount);
        return sb.toString();
    }

    public List<GenQueryOrderByField> getOrderByFields() {
        return this.orderByFields;
    }

    public boolean isUpperCase() {
        return this.upperCase;
    }

    public boolean isComputeTotalRowCount() {
        return this.computeTotalRowCount;
    }
}

