/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.transfer;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import org.irods.jargon.core.connection.ConnectionProgressStatus;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.transfer.AbstractParallelTransferThread;
import org.irods.jargon.core.transfer.ParallelGetFileTransferStrategy;
import org.irods.jargon.core.transfer.ParallelTransferResult;
import org.irods.jargon.core.transfer.encrypt.ParallelDecryptionCipherWrapper;
import org.irods.jargon.core.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParallelGetTransferThread
extends AbstractParallelTransferThread
implements Callable<ParallelTransferResult> {
    private final ParallelGetFileTransferStrategy parallelGetFileTransferStrategy;
    private ParallelDecryptionCipherWrapper parallelDecryptionCipherWrapper;
    public static final Logger log = LoggerFactory.getLogger(ParallelGetTransferThread.class);

    public static ParallelGetTransferThread instance(ParallelGetFileTransferStrategy parallelGetFileTransferStrategy, int threadNumber) throws JargonException {
        return new ParallelGetTransferThread(parallelGetFileTransferStrategy, threadNumber);
    }

    private ParallelGetTransferThread(ParallelGetFileTransferStrategy parallelGetFileTransferStrategy, int threadNumber) throws JargonException {
        super(threadNumber);
        if (parallelGetFileTransferStrategy == null) {
            throw new JargonException("parallelGetFileTransferStrategy is null");
        }
        this.parallelGetFileTransferStrategy = parallelGetFileTransferStrategy;
        log.info("setting up the encryption if so negotiated");
        if (this.parallelGetFileTransferStrategy.doEncryption()) {
            log.debug("am doing encryption, enable the cypher");
            this.parallelDecryptionCipherWrapper = this.parallelGetFileTransferStrategy.initializeCypherForDecryption();
            log.debug("cypher initialized");
        }
    }

    @Override
    public ParallelTransferResult call() throws JargonException {
        try {
            Socket s = new Socket();
            if (this.parallelGetFileTransferStrategy.getPipelineConfiguration().getParallelTcpSendWindowSize() > 0) {
                s.setSendBufferSize(this.parallelGetFileTransferStrategy.getPipelineConfiguration().getParallelTcpSendWindowSize() * 1024);
            }
            if (this.parallelGetFileTransferStrategy.getPipelineConfiguration().getParallelTcpReceiveWindowSize() > 0) {
                s.setReceiveBufferSize(this.parallelGetFileTransferStrategy.getPipelineConfiguration().getParallelTcpReceiveWindowSize() * 1024);
            }
            s.setPerformancePreferences(this.parallelGetFileTransferStrategy.getPipelineConfiguration().getParallelTcpPerformancePrefsConnectionTime(), this.parallelGetFileTransferStrategy.getPipelineConfiguration().getParallelTcpPerformancePrefsLatency(), this.parallelGetFileTransferStrategy.getPipelineConfiguration().getParallelTcpPerformancePrefsBandwidth());
            InetSocketAddress address = new InetSocketAddress(this.parallelGetFileTransferStrategy.getHost(), this.parallelGetFileTransferStrategy.getPort());
            s.setSoTimeout(this.parallelGetFileTransferStrategy.getParallelSocketTimeoutInSecs() * 1000);
            s.setKeepAlive(this.parallelGetFileTransferStrategy.getPipelineConfiguration().isParallelTcpKeepAlive());
            s.setReuseAddress(true);
            s.setTcpNoDelay(false);
            s.connect(address);
            this.setS(s);
            byte[] outputBuffer = new byte[4];
            Host.copyInt(this.parallelGetFileTransferStrategy.getPassword(), outputBuffer);
            int inputBuffSize = this.parallelGetFileTransferStrategy.getJargonProperties().getInternalInputStreamBufferSize();
            int outputBuffSize = this.parallelGetFileTransferStrategy.getJargonProperties().getInternalOutputStreamBufferSize();
            if (inputBuffSize < 0) {
                this.setIn(this.getS().getInputStream());
            } else if (inputBuffSize == 0) {
                this.setIn(new BufferedInputStream(this.getS().getInputStream()));
            } else {
                this.setIn(new BufferedInputStream(this.getS().getInputStream(), inputBuffSize));
            }
            if (outputBuffSize < 0) {
                this.setOut(this.getS().getOutputStream());
            } else if (outputBuffSize == 0) {
                this.setOut(new BufferedOutputStream(this.getS().getOutputStream()));
            } else {
                this.setOut(new BufferedOutputStream(this.getS().getOutputStream(), outputBuffSize));
            }
            log.debug("socket established, sending cookie to iRODS listener");
            this.getOut().write(outputBuffer);
            this.getOut().flush();
            log.debug("cookie written");
            log.info("sockets are open and password sent, now begin the get operation");
            this.get();
            log.info("exiting get and returning the finish object");
            ParallelTransferResult result = new ParallelTransferResult();
            result.transferException = this.getExceptionInTransfer();
            return result;
        }
        catch (UnknownHostException e) {
            log.error("Unknown host: {}", (Object)this.parallelGetFileTransferStrategy.getHost(), (Object)e);
            this.setExceptionInTransfer(e);
            throw new JargonException("unknown host:" + this.parallelGetFileTransferStrategy.getHost(), e);
        }
        catch (Throwable e) {
            log.error("unchecked exception in transfer", e);
            throw new JargonException(e);
        }
    }

    public void get() throws JargonException {
        log.info("parallel transfer get");
        if (this.parallelGetFileTransferStrategy.getConnectionProgressStatusListener() == null) {
            log.info("no connection progress status listener configured, no detailed callbacks");
        } else {
            log.info("connection listener configured, will produce callbacks");
        }
        RandomAccessFile local = null;
        try {
            log.info("opening local randomAccessFile");
            local = new RandomAccessFile(this.parallelGetFileTransferStrategy.getLocalFile(), "rw");
            log.info("random access file opened rw mode");
            this.processingLoopForGetData(local);
        }
        catch (JargonException je) {
            log.error("a jargon exception occurred in the get loop");
            throw je;
        }
        catch (Exception e) {
            log.error("Exception closing local file", (Throwable)e);
            throw new JargonException("IOException closing local file");
        }
        finally {
            log.info("parallel thread closing out local random access file stream");
            try {
                log.info("closing sockets, this close eats exceptions");
                this.close();
                log.info("closing local file");
                if (local != null) {
                    local.close();
                }
                log.info("local file closed, exiting get() method");
            }
            catch (IOException iOException) {}
        }
    }

    private void processingLoopForGetData(RandomAccessFile local) throws JargonException {
        int operation = this.readInt();
        this.readInt();
        long offset = this.readLong();
        long length = this.readLong();
        log.info(">>>new offset:{}", (Object)offset);
        log.info(">>>new length:{}", (Object)length);
        byte[] buffer = null;
        int read = 0;
        if (operation != 2) {
            log.error("Parallel transfer expected GET,  server requested {}", (Object)operation);
            throw new JargonException("parallel get transfer, unexpected transfer type from iRODS:" + operation);
        }
        log.info("seeking to offset: {}", (Object)offset);
        try {
            this.seekToOffset(local, offset);
            long totalWrittenSinceLastRestartUpdate = 0L;
            while (length > 0L) {
                int newSize;
                if (Thread.interrupted()) {
                    throw new IOException("interrupted, consider connection corrupted and return IOException to clear");
                }
                log.debug("reading....");
                if (this.parallelGetFileTransferStrategy.doEncryption()) {
                    newSize = Integer.reverseBytes(this.readInt());
                    log.debug("new size of encrypted traffic:{}", (Object)newSize);
                } else {
                    newSize = Math.min(this.parallelGetFileTransferStrategy.getJargonProperties().getParallelCopyBufferSize(), (int)length);
                    log.debug("newSize of non-encrypted traffic:{}", (Object)newSize);
                }
                if (newSize <= 0) {
                    return;
                }
                buffer = new byte[newSize];
                read = this.myRead(this.getIn(), buffer, newSize);
                if (this.parallelGetFileTransferStrategy.doEncryption()) {
                    buffer = this.parallelDecryptionCipherWrapper.decrypt(buffer);
                    read = buffer.length;
                }
                totalWrittenSinceLastRestartUpdate += (long)read;
                if (read > 0) {
                    if ((length -= (long)read) == 0L) {
                        local.write(buffer, 0, read);
                        if (this.parallelGetFileTransferStrategy.getConnectionProgressStatusListener() != null) {
                            this.parallelGetFileTransferStrategy.getConnectionProgressStatusListener().connectionProgressStatusCallback(ConnectionProgressStatus.instanceForReceive(read));
                        }
                        if (this.parallelGetFileTransferStrategy.getFileRestartInfo() != null) {
                            this.parallelGetFileTransferStrategy.getRestartManager().updateLengthForSegment(this.parallelGetFileTransferStrategy.getFileRestartInfo().identifierFromThisInfo(), this.getThreadNumber(), totalWrittenSinceLastRestartUpdate);
                            totalWrittenSinceLastRestartUpdate = 0L;
                            log.debug("signal storage of new info");
                        }
                        operation = this.readInt();
                        this.readInt();
                        offset = this.readLong();
                        length = this.readLong();
                        log.info(">>>new offset:{}", (Object)offset);
                        log.info(">>>new length:{}", (Object)length);
                        if (operation == 9999) break;
                        this.seekToOffset(local, offset);
                    } else {
                        if (length < 0L) {
                            String msg = "length < 0 passed in header from iRODS during parallel get operation";
                            log.error(msg);
                            throw new JargonException(msg);
                        }
                        local.write(buffer, 0, read);
                        if (this.parallelGetFileTransferStrategy.getConnectionProgressStatusListener() != null) {
                            this.parallelGetFileTransferStrategy.getConnectionProgressStatusListener().connectionProgressStatusCallback(ConnectionProgressStatus.instanceForReceive(read));
                        }
                    }
                } else {
                    log.warn("intercepted a loop condition on parallel file get, length is > 0 but I just read and got nothing...breaking...");
                    length = 0L;
                    throw new JargonException("possible loop condition in parallel file get");
                }
                Thread.yield();
            }
        }
        catch (IOException e) {
            log.error("IOExeption in parallel transfer", (Object)this.parallelGetFileTransferStrategy.toString());
            throw new JargonException("IOException occurred during parallel file transfer", e);
        }
        catch (Throwable e) {
            log.error("exception in parallel transfer", e);
            throw new JargonException("unexpected exception in parallel transfer", e);
        }
    }

    private int myRead(InputStream in, byte[] buffer, int length) throws IOException, JargonException {
        int myLength = length;
        int ptr = 0;
        int read = 0;
        int totalRead = 0;
        if (buffer.length < length) {
            throw new JargonException("attempting to read more than buffer");
        }
        while (myLength > 0) {
            log.info(">>>>>>>>>>>>> top of while, my length:{} <<<<<<<<<<<", (Object)myLength);
            if (ptr > buffer.length) {
                log.error("ptr out of synch");
                log.error("buffer size:{}", (Object)buffer.length);
                log.error("ptr:{}", (Object)ptr);
                log.error("myLength:{}", (Object)myLength);
                log.error("totalRead:{}", (Object)totalRead);
                throw new JargonException("pointer is pointing out of range of the buffer");
            }
            log.info("===========================");
            log.info("ptr:{}", (Object)ptr);
            log.info("myLength:{}", (Object)myLength);
            read = in.read(buffer, ptr, myLength);
            log.info(">>> read:{}", (Object)read);
            if (read < 0) {
                log.error("read < 0");
                break;
            }
            ptr += read;
            log.info("total read now:{}", (Object)(totalRead += read));
            log.info("out of original length:{}", (Object)length);
            log.info("makes my length:{}", (Object)(myLength -= read));
        }
        if (totalRead != length) {
            log.error("did not read expected length in myRead()");
            throw new JargonException("did not read expected length");
        }
        return totalRead;
    }

    private void seekToOffset(RandomAccessFile local, long offset) throws JargonException {
        if (offset < 0L) {
            log.error("offset < 0 in transfer get() operation, return from get method");
            return;
        }
        if (offset > 0L) {
            if (this.parallelGetFileTransferStrategy.getFileRestartInfo() != null) {
                this.parallelGetFileTransferStrategy.getRestartManager().updateOffsetForSegment(this.parallelGetFileTransferStrategy.getFileRestartInfo().identifierFromThisInfo(), this.getThreadNumber(), offset);
            }
            try {
                if (offset == local.getFilePointer()) {
                    return;
                }
                local.seek(offset);
            }
            catch (Exception e) {
                log.error("IOExeption in parallel transfer", (Object)this.parallelGetFileTransferStrategy.toString());
                throw new JargonException("IOException occurred during parallel file transfer", e);
            }
        }
    }
}

