/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.util.Date;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.pub.RuleProcessingAOImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileUtils {
    public static final Logger log = LoggerFactory.getLogger(LocalFileUtils.class);

    private LocalFileUtils() {
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null fileName");
        }
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return fileName.substring(lastDot);
    }

    public static String normalizePath(String inPath) {
        if (inPath == null) {
            throw new IllegalArgumentException("null inPath");
        }
        if (File.separatorChar != '\\') {
            return inPath;
        }
        return inPath.replaceAll("\\\\", "/");
    }

    public static String getFileNameUpToExtension(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            throw new IllegalArgumentException("null fileName");
        }
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return fileName.substring(0, lastDot);
    }

    public static String getFileNameWithTimeStampInterposed(String fileName) {
        String namePart = LocalFileUtils.getFileNameUpToExtension(fileName);
        String extension = LocalFileUtils.getFileExtension(fileName);
        StringBuilder newName = new StringBuilder(namePart);
        newName.append(".[backup from - ");
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        newName.append(dateFormat.format(new Date()));
        newName.append("]");
        newName.append(extension);
        return newName.toString();
    }

    public static int countFilesInDirectory(File directory) {
        if (directory == null) {
            throw new IllegalArgumentException("null directory");
        }
        int count = 0;
        if (directory.isFile()) {
            count = 1;
        } else {
            File[] files = directory.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isFile()) {
                        ++count;
                    }
                    if (!file.isDirectory()) continue;
                    count += LocalFileUtils.countFilesInDirectory(file);
                }
            }
        }
        return count;
    }

    public static void createLocalFileIfNotExists(File localFileToHoldData) throws JargonException {
        if (localFileToHoldData.exists()) {
            log.info("local file exists, will not create the local file for {}", (Object)localFileToHoldData.getAbsolutePath());
        } else {
            log.info("local file does not exist, will attempt to create local file: {}", (Object)localFileToHoldData.getAbsolutePath());
            try {
                localFileToHoldData.createNewFile();
            }
            catch (IOException e) {
                log.error("IOException when trying to create a new file for the local output stream for {}", (Object)localFileToHoldData.getAbsolutePath(), (Object)e);
                throw new JargonException("IOException trying to create new file: " + localFileToHoldData.getAbsolutePath(), e);
            }
        }
    }

    public static long computeCRC32FileCheckSumViaAbsolutePath(String absolutePathToLocalFile) throws JargonException {
        FileInputStream file;
        try {
            file = new FileInputStream(absolutePathToLocalFile);
        }
        catch (FileNotFoundException e1) {
            throw new JargonException("error computing checksum, file not found:" + absolutePathToLocalFile, e1);
        }
        CheckedInputStream check = new CheckedInputStream(file, new CRC32());
        BufferedInputStream in = new BufferedInputStream(check);
        try {
            while (in.read() != -1) {
            }
        }
        catch (IOException e) {
            throw new JargonException("error computing checksum for file:" + absolutePathToLocalFile, e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return check.getChecksum().getValue();
    }

    public static byte[] computeSHA256FileCheckSumViaAbsolutePath(String absolutePathToLocalFile) throws JargonException {
        FileInputStream file;
        log.info("computeSHA256FileCheckSumViaAbsolutePath()");
        if (absolutePathToLocalFile == null || absolutePathToLocalFile.isEmpty()) {
            throw new IllegalArgumentException("null or empty absolutePathToLocalFile");
        }
        try {
            file = new FileInputStream(absolutePathToLocalFile);
        }
        catch (FileNotFoundException e1) {
            throw new JargonException("error computing checksum, file not found:" + absolutePathToLocalFile, e1);
        }
        BufferedInputStream in = new BufferedInputStream(file);
        byte[] buffer = new byte[4096];
        try {
            int numRead;
            MessageDigest complete = MessageDigest.getInstance("SHA-256");
            do {
                if ((numRead = in.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] byArray = complete.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new JargonException("no such algorithm exception for MD5");
        }
        catch (Exception e) {
            throw new JargonException("Error computing MD5 checksum", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                file.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] computeMD5FileCheckSumViaAbsolutePath(String absolutePathToLocalFile) throws JargonException {
        FileInputStream file;
        try {
            file = new FileInputStream(absolutePathToLocalFile);
        }
        catch (FileNotFoundException e1) {
            throw new JargonException("error computing checksum, file not found:" + absolutePathToLocalFile, e1);
        }
        BufferedInputStream in = new BufferedInputStream(file);
        byte[] buffer = new byte[4096];
        try {
            int numRead;
            MessageDigest complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = in.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] byArray = complete.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException e) {
            throw new JargonException("no such algorithm exception for MD5");
        }
        catch (Exception e) {
            throw new JargonException("Error computing MD5 checksum", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                file.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String digestByteArrayToString(byte[] digestAsByteArray) {
        if (digestAsByteArray == null) {
            throw new IllegalArgumentException("unknown format, not recognized as an MD5 checksum in a byte array");
        }
        StringBuilder sb = new StringBuilder();
        for (byte element : digestAsByteArray) {
            sb.append(String.format("%02x", element));
        }
        return sb.toString();
    }

    public static File getClasspathResourceAsFile(String resourcePath) throws JargonException {
        if (resourcePath == null || resourcePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourcePath");
        }
        URL resourceUrl = LocalFileUtils.class.getResource(resourcePath);
        if (resourceUrl == null) {
            throw new JargonException("null resource, cannot find file");
        }
        try {
            File resourceFile = new File(resourceUrl.toURI());
            if (!resourceFile.exists()) {
                throw new JargonException("resource file does not exist");
            }
            return resourceFile;
        }
        catch (URISyntaxException e) {
            throw new JargonException("unable to create uri from file path");
        }
    }

    public static String getClasspathResourceFileAsString(String resourcePath) throws JargonException {
        if (resourcePath == null || resourcePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty resourcePath");
        }
        InputStreamReader resourceReader = new InputStreamReader(new BufferedInputStream(RuleProcessingAOImpl.class.getResourceAsStream(resourcePath)));
        StringWriter writer = null;
        String ruleString = null;
        try {
            writer = new StringWriter();
            char[] buff = new char[1024];
            int i = 0;
            while ((i = resourceReader.read(buff)) > -1) {
                writer.write(buff, 0, i);
            }
            ruleString = writer.toString();
        }
        catch (IOException ioe) {
            log.error("io exception reading rule data from resource", (Throwable)ioe);
            throw new JargonException("error reading rule from resource", ioe);
        }
        finally {
            try {
                resourceReader.close();
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
        return ruleString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        byte[] bytes;
        try (FileInputStream is = new FileInputStream(file);){
            int offset;
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        return bytes;
    }
}

