/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v1;

import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.Destroyable;
import org.cryptomator.cryptolib.api.FileHeader;

class FileHeaderImpl
implements FileHeader,
Destroyable {
    static final int NONCE_POS = 0;
    static final int NONCE_LEN = 16;
    static final int PAYLOAD_POS = 16;
    static final int PAYLOAD_LEN = 40;
    static final int MAC_POS = 56;
    static final int MAC_LEN = 32;
    static final int SIZE = 88;
    private final byte[] nonce;
    private final Payload payload;

    FileHeaderImpl(byte[] nonce, byte[] contentKey) {
        if (nonce.length != 16) {
            throw new IllegalArgumentException("Invalid nonce length. (was: " + nonce.length + ", required: " + 16 + ")");
        }
        this.nonce = nonce;
        this.payload = new Payload(contentKey);
    }

    static FileHeaderImpl cast(FileHeader header) {
        if (header instanceof FileHeaderImpl) {
            return (FileHeaderImpl)header;
        }
        throw new IllegalArgumentException("Unsupported header type " + header.getClass());
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public Payload getPayload() {
        return this.payload;
    }

    @Override
    public long getFilesize() {
        return this.payload.getFilesize();
    }

    @Override
    public void setFilesize(long filesize) {
        this.payload.setFilesize(filesize);
    }

    @Override
    public boolean isDestroyed() {
        return this.payload.isDestroyed();
    }

    @Override
    public void destroy() {
        this.payload.destroy();
    }

    public static class Payload
    implements Destroyable {
        static final int FILESIZE_POS = 0;
        static final int FILESIZE_LEN = 8;
        static final int CONTENT_KEY_POS = 8;
        static final int CONTENT_KEY_LEN = 32;
        static final int SIZE = 40;
        private static final byte[] EMPTY_CONTENT_KEY = new byte[32];
        private long filesize = -1L;
        private final byte[] contentKeyBytes;
        private final SecretKey contentKey;

        private Payload(byte[] contentKeyBytes) {
            if (contentKeyBytes.length != 32) {
                throw new IllegalArgumentException("Invalid key length. (was: " + contentKeyBytes.length + ", required: " + 32 + ")");
            }
            this.contentKeyBytes = contentKeyBytes;
            this.contentKey = new SecretKeySpec(contentKeyBytes, "AES");
        }

        private long getFilesize() {
            return this.filesize;
        }

        private void setFilesize(long filesize) {
            this.filesize = filesize;
        }

        SecretKey getContentKey() {
            return this.contentKey;
        }

        byte[] getContentKeyBytes() {
            return this.contentKeyBytes;
        }

        @Override
        public boolean isDestroyed() {
            return Arrays.equals(this.contentKeyBytes, EMPTY_CONTENT_KEY);
        }

        @Override
        public void destroy() {
            Arrays.fill(this.contentKeyBytes, (byte)0);
        }
    }
}

