NAME = 'RSS in SAX'
VERSION = '0.1'

# Copyright (c) 2005 Jose Nazario

# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:

# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.

# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

__copyright__ = 'Copyright (c) 2005 Jose Nazario'

import os, sys, xml.sax, urllib

class rssHandler(xml.sax.ContentHandler):
    """lifted from the feedster API"""
    def startDocument(self):
        self.data={'title': '', 'link': '', 'description': ''}
        self.text=""
        self.out=[]

    def startElement(self,tag,attributes):
        self.text = ''
        if tag == 'item':
            pass

    def endElement(self,tag):
        if tag == 'item':
            self.out.append(self.data)
            self.data = {}
        else:
            self.data[tag] = self.text.strip()
            self.text = ''

    def characters(self,content):
            self.text = self.text + content
