__author__ = "Toru Itami (titami0120@yahoo.co.jp)"
__version__ = "0.1"
__date__ = "2005/01/01"

import os, urllib
from xml.dom import minidom

LICENSE_KEY = None
SUBSCRIPTION_ID = None
HTTP_PROXY = None

class AlexaError(Exception): pass
class NoSubscriptionId(Exception): pass
class NoLicenseKey(Exception): pass
_alexafile1 = ".alexakey"
_alexafile2 = "alexakey.txt"
_licenseLocations = (
    (lambda key: key, 'passed to the function in license_key variable'),
    (lambda key: LICENSE_KEY, 'module-level LICENSE_KEY variable (call setLicense to set it)'),
    (lambda key: os.environ.get('ALEXA_LICENSE_KEY', None), 'an environment variable called ALEXA_LICENSE_KEY'),
    (lambda key: _contentsOf(os.getcwd(), _alexafile1), '%s in the current directory' % _alexafile1),
    (lambda key: _contentsOf(os.getcwd(), _alexafile2), '%s in the current directory' % _alexafile2),
    (lambda key: _contentsOf(os.environ.get('HOME', ''), _alexafile1), '%s in your home directory' % _alexafile1),
    (lambda key: _contentsOf(os.environ.get('HOME', ''), _alexafile2), '%s in your home directory' % _alexafile2),
    (lambda key: _contentsOf(_getScriptDir(), _alexafile1), '%s in the alexa.py directory' % _alexafile1),
    (lambda key: _contentsOf(_getScriptDir(), _alexafile2), '%s in the alexa.py directory' % _alexafile2)
    )


class Bag: pass
def unmarshal(element):
    rc = Bag()
    childElements = [e for e in element.childNodes if isinstance(e, minidom.Element)]
    if childElements:
        for child in childElements:
            key = child.tagName
            if hasattr(rc, key):
                if type(getattr(rc, key)) != type([]):
                    setattr(rc, key, [getattr(rc, key)])
                setattr(rc, key, getattr(rc, key) + [unmarshal(child)])
            else:
                setattr(rc, key, [unmarshal(child)])
    else:
        rc = "".join([e.data for e in element.childNodes if isinstance(e, minidom.Text)])

    return rc

def _contentsOf(dirname, filename):
    filename = os.path.join(dirname, filename)
    if not os.path.exists(filename): return None
    fsock = open(filename)
    contents =  fsock.read().strip()
    fsock.close()
    return contents

def _getScriptDir():
    if __name__ == '__main__':
        return os.path.abspath(os.path.dirname(sys.argv[0]))
    else:
        return os.path.abspath(os.path.dirname(sys.modules[__name__].__file__))

def getLicense(license_key = None):
    """get license key

    license key can come from any number of locations;
    see module docs for search order"""
    for get, location in _licenseLocations:
        rc = get(license_key)
        if rc: return rc
    raise NoLicenseKey, 'get a license key!'

def setSubscriptionId(subscription_id):
    """set subscription id"""
    global SUBSCRIPTION_ID
    SUBSCRIPTION_ID = subscription_id

def getSubscriptionId():
    """get subscription id"""
    global SUBSCRIPTION_ID
    SUBSCRIPTION_ID = getLicense()
    if SUBSCRIPTION_ID:
        return SUBSCRIPTION_ID
    raise NoSubscriptionId, 'get a SubscriptionId key at http://www.amazon.com/webservices'

def setProxy(http_proxy):
    """set HTTP proxy"""
    global HTTP_PROXY
    HTTP_PROXY = http_proxy

def getProxy():
    """get HTTP proxy"""
    return HTTP_PROXY

def buildURL(operation,responseGroup,query):
    url = 'http://awis.amazonaws.com/onca/soap?Service=AlexaWebInfoService'
    url += "&SubscriptionId=%s" % getSubscriptionId()
    url += "&Operation=%s" % operation
    url += "&ResponseGroup=%s" % responseGroup
    url += query
    return url

def getData(url):
    u = urllib.FancyURLopener(getProxy())
    usock = u.open(url)
    xmldoc = minidom.parse(usock)
    usock.close()
    # from xml.dom.ext import PrettyPrint
    # PrettyPrint(xmldoc)    
    data = unmarshal(xmldoc)
    return data

def category(path,mode=None):
    responseGroup = "Browse"
    query = "&Path=%s" % path
    if mode:
        query += "&Mode=%s" % mode
    url = buildURL("Category",responseGroup,query)
    data = getData(url)

    if not hasattr(data,"CategoryResponse"):
        raise AlexaError,"Error"
    categoryResult = data.CategoryResponse[0].CategoryResult[0]
    if categoryResult.Request[0].IsValid[0] != "True":
        raise AlexaError,urlInfoResult.Request[0].Errors[0].Error[0].Message[0]
    return categoryResult.Alexa[0]

def crawl(query_url,start=None,count=None,purify=None):
    responseGroup = "MetaData"
    query = "&Url=%s" % query_url
    if start:
        query += "&Start=%s" % start
    if count:
        query += "&Count=%s" % count
    if purify:
        query += "&Purify=%s" % purify
    url = buildURL("Crawl",responseGroup,query)
    data = getData(url)

    if not hasattr(data,"CrawlResponse"):
        raise AlexaError,"Error"
    crawlResult = data.CrawlResponse[0].CrawlResult[0]
    if crawlResult.Request[0].IsValid[0] != "True":
        raise AlexaError,crawlResult.Request[0].Errors[0].Error[0].Message[0]
    return crawlResult.Alexa[0]

def search(searchTerm,timeOut=None,maxResultsPerHost=None,
           duplicateCheck=None,countOnly=None,context=None,
           relevance=None,ignoreWords=None,start=None,
           count=None,adultFilter=None):
    responseGroup = "Web"
    query = "&Query=%s" % searchTerm
    url = buildURL("Search",responseGroup,query)
    data = getData(url)

    if not hasattr(data,"SearchResponse"):
        raise AlexaError,"Error"
    searchResult = data.SearchResponse[0].SearchResult[0]
    if searchResult.Request[0].IsValid[0] != "True":
        raise AlexaError,searchResult.Request[0].Errors[0].Error[0].Message[0]
    return searchResult.Alexa[0]    

def urlInfo(responseGroup,query_url):
    query = "&Url=%s" % query_url
    url = buildURL("UrlInfo",responseGroup,query)
    data = getData(url)

    if not hasattr(data,"UrlInfoResponse"):
        raise AlexaError,"Error"
    urlInfoResult = data.UrlInfoResponse[0].UrlInfoResult[0]
    if urlInfoResult.Request[0].IsValid[0] != "True":
        raise AlexaError,urlInfoResult.Request[0].Errors[0].Error[0].Message[0]
    return urlInfoResult.Alexa[0]

def webMap(responseGroup,query_url,start=None,count=None):
    query = "&Url=%s" % query_url
    if start:
        query += "&Start=%s" % start
    if count:
        query += "&Count=%s" % count
    url = buildURL("WebMap",responseGroup,query)
    data = getData(url)

    if not hasattr(data,"WebMapResponse"):
        raise AlexaError,"Error"
    webMapResult = data.WebMapResponse[0].WebMapResult[0]
    if webMapResult.Request[0].IsValid[0] != "True":
        raise AlexaError,webMapResult.Request[0].Errors[0].Error[0].Message[0]
    return webMapResult.Alexa[0]

if __name__ == "__main__":
    import alexa
    alexa.setSubscriptionId(getLicense())

    ##usage urlInfo
    data = alexa.urlInfo("Rank,Related","amazon.co.jp")
    print data.TrafficData[0].Rank[0]
    for cat in data.Related[0].Categories[0].CategoryData:
        print cat.AbsolutePath[0]

    ##usage category
    data = alexa.category("Top/Computers/Programming/Languages/Python")
    for link in data.Browse[0].MostPopular[0].Links[0].Link:
        print link.Title[0],link.NavigableUrl[0]

    ##usage crawl
    data = alexa.crawl("google.co.jp")
    for metadata in data.CrawlData[0].MetaData:
        print metadata.RequestInfo[0].RequestDate[0],':',metadata.RequestInfo[0].IPAddress[0]

    ##usage search
    data = alexa.search("plone")
    for result in data.WebSearch[0].Results[0].Result:
        print result.DataUrl[0]

    ##usage webMap
    data = alexa.webMap("LinksIn","yahoo.co.jp")
    print data.WebMapData[0].LinksPointingIn[0].Total[0]
    data = alexa.webMap("LinksOut","yahoo.co.jp")
    print data.WebMapData[0].LinksPointingOut[0].Total[0]
