/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.api;

import java.io.IOException;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.json.JsonXContent;

public class Json {
    public static Object load(String json) throws IOException {
        XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, json);
        switch (parser.nextToken()) {
            case START_ARRAY: {
                return parser.list();
            }
            case START_OBJECT: {
                return parser.map();
            }
            case VALUE_NUMBER: {
                return parser.numberValue();
            }
            case VALUE_BOOLEAN: {
                return parser.booleanValue();
            }
            case VALUE_STRING: {
                return parser.text();
            }
        }
        return null;
    }

    public static String dump(Object data) throws IOException {
        return Json.dump(data, false);
    }

    public static String dump(Object data, boolean pretty) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder();
        if (pretty) {
            builder.prettyPrint();
        }
        builder.value(data);
        builder.flush();
        return builder.getOutputStream().toString();
    }
}

