/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.spatial.index.fielddata.DimensionalShapeType;
import org.elasticsearch.xpack.spatial.index.fielddata.GeoShapeValues;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoShapeValuesSource;

public final class GeoShapeCentroidAggregator
extends MetricsAggregator {
    private final GeoShapeValuesSource valuesSource;
    private DoubleArray lonSum;
    private DoubleArray lonCompensations;
    private DoubleArray latSum;
    private DoubleArray latCompensations;
    private DoubleArray weightSum;
    private DoubleArray weightCompensations;
    private LongArray counts;
    private ByteArray dimensionalShapeTypes;

    public GeoShapeCentroidAggregator(String name, AggregationContext context, Aggregator parent, ValuesSourceConfig valuesSourceConfig, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        GeoShapeValuesSource geoShapeValuesSource = this.valuesSource = valuesSourceConfig.hasValues() ? (GeoShapeValuesSource)valuesSourceConfig.getValuesSource() : null;
        if (this.valuesSource != null) {
            this.lonSum = this.bigArrays().newDoubleArray(1L, true);
            this.lonCompensations = this.bigArrays().newDoubleArray(1L, true);
            this.latSum = this.bigArrays().newDoubleArray(1L, true);
            this.latCompensations = this.bigArrays().newDoubleArray(1L, true);
            this.weightSum = this.bigArrays().newDoubleArray(1L, true);
            this.weightCompensations = this.bigArrays().newDoubleArray(1L, true);
            this.counts = this.bigArrays().newLongArray(1L, true);
            this.dimensionalShapeTypes = this.bigArrays().newByteArray(1L, true);
        }
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final GeoShapeValues values = this.valuesSource.geoShapeValues(ctx);
        final CompensatedSum compensatedSumLat = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumLon = new CompensatedSum(0.0, 0.0);
        final CompensatedSum compensatedSumWeight = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                if (values.advanceExact(doc)) {
                    this.maybeResize(bucket);
                    GeoShapeCentroidAggregator.this.counts.increment(bucket, 1L);
                    DimensionalShapeType shapeType = DimensionalShapeType.fromOrdinalByte(GeoShapeCentroidAggregator.this.dimensionalShapeTypes.get(bucket));
                    GeoShapeValues.GeoShapeValue value = values.value();
                    int compares = shapeType.compareTo(value.dimensionalShapeType());
                    if (compares < 0) {
                        double coordinateWeight = value.weight();
                        compensatedSumLat.reset(coordinateWeight * value.lat(), 0.0);
                        compensatedSumLon.reset(coordinateWeight * value.lon(), 0.0);
                        compensatedSumWeight.reset(coordinateWeight, 0.0);
                        GeoShapeCentroidAggregator.this.dimensionalShapeTypes.set(bucket, (byte)value.dimensionalShapeType().ordinal());
                    } else if (compares == 0) {
                        compensatedSumLat.reset(GeoShapeCentroidAggregator.this.latSum.get(bucket), GeoShapeCentroidAggregator.this.latCompensations.get(bucket));
                        compensatedSumLon.reset(GeoShapeCentroidAggregator.this.lonSum.get(bucket), GeoShapeCentroidAggregator.this.lonCompensations.get(bucket));
                        compensatedSumWeight.reset(GeoShapeCentroidAggregator.this.weightSum.get(bucket), GeoShapeCentroidAggregator.this.weightCompensations.get(bucket));
                        double coordinateWeight = value.weight();
                        compensatedSumLat.add(coordinateWeight * value.lat());
                        compensatedSumLon.add(coordinateWeight * value.lon());
                        compensatedSumWeight.add(coordinateWeight);
                    } else {
                        return;
                    }
                    GeoShapeCentroidAggregator.this.lonSum.set(bucket, compensatedSumLon.value());
                    GeoShapeCentroidAggregator.this.lonCompensations.set(bucket, compensatedSumLon.delta());
                    GeoShapeCentroidAggregator.this.latSum.set(bucket, compensatedSumLat.value());
                    GeoShapeCentroidAggregator.this.latCompensations.set(bucket, compensatedSumLat.delta());
                    GeoShapeCentroidAggregator.this.weightSum.set(bucket, compensatedSumWeight.value());
                    GeoShapeCentroidAggregator.this.weightCompensations.set(bucket, compensatedSumWeight.delta());
                }
            }

            private void maybeResize(long bucket) {
                GeoShapeCentroidAggregator.this.latSum = GeoShapeCentroidAggregator.this.bigArrays().grow(GeoShapeCentroidAggregator.this.latSum, bucket + 1L);
                GeoShapeCentroidAggregator.this.lonSum = GeoShapeCentroidAggregator.this.bigArrays().grow(GeoShapeCentroidAggregator.this.lonSum, bucket + 1L);
                GeoShapeCentroidAggregator.this.weightSum = GeoShapeCentroidAggregator.this.bigArrays().grow(GeoShapeCentroidAggregator.this.weightSum, bucket + 1L);
                GeoShapeCentroidAggregator.this.lonCompensations = GeoShapeCentroidAggregator.this.bigArrays().grow(GeoShapeCentroidAggregator.this.lonCompensations, bucket + 1L);
                GeoShapeCentroidAggregator.this.latCompensations = GeoShapeCentroidAggregator.this.bigArrays().grow(GeoShapeCentroidAggregator.this.latCompensations, bucket + 1L);
                GeoShapeCentroidAggregator.this.weightCompensations = GeoShapeCentroidAggregator.this.bigArrays().grow(GeoShapeCentroidAggregator.this.weightCompensations, bucket + 1L);
                GeoShapeCentroidAggregator.this.counts = GeoShapeCentroidAggregator.this.bigArrays().grow(GeoShapeCentroidAggregator.this.counts, bucket + 1L);
                GeoShapeCentroidAggregator.this.dimensionalShapeTypes = GeoShapeCentroidAggregator.this.bigArrays().grow(GeoShapeCentroidAggregator.this.dimensionalShapeTypes, bucket + 1L);
            }
        };
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        long bucketCount = this.counts.get(bucket);
        double bucketWeight = this.weightSum.get(bucket);
        GeoPoint bucketCentroid = bucketWeight > 0.0 ? new GeoPoint(this.latSum.get(bucket) / bucketWeight, this.lonSum.get(bucket) / bucketWeight) : null;
        return new InternalGeoCentroid(this.name, bucketCentroid, bucketCount, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoCentroid(this.name, null, 0L, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.latSum, this.latCompensations, this.lonSum, this.lonCompensations, this.counts, this.weightSum, this.weightCompensations, this.dimensionalShapeTypes});
    }
}

