/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.matchingrules;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.matchingrules.MatchingRule;
import com.unboundid.ldap.matchingrules.MatchingRuleMessages;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class IntegerMatchingRule
extends MatchingRule {
    private static final IntegerMatchingRule INSTANCE = new IntegerMatchingRule();
    public static final String EQUALITY_RULE_NAME = "integerMatch";
    static final String LOWER_EQUALITY_RULE_NAME = StaticUtils.toLowerCase("integerMatch");
    public static final String EQUALITY_RULE_OID = "2.5.13.14";
    public static final String ORDERING_RULE_NAME = "integerOrderingMatch";
    static final String LOWER_ORDERING_RULE_NAME = StaticUtils.toLowerCase("integerOrderingMatch");
    public static final String ORDERING_RULE_OID = "2.5.13.15";
    private static final long serialVersionUID = -9056942146971528818L;

    public static IntegerMatchingRule getInstance() {
        return INSTANCE;
    }

    @Override
    public String getEqualityMatchingRuleName() {
        return EQUALITY_RULE_NAME;
    }

    @Override
    public String getEqualityMatchingRuleOID() {
        return EQUALITY_RULE_OID;
    }

    @Override
    public String getOrderingMatchingRuleName() {
        return ORDERING_RULE_NAME;
    }

    @Override
    public String getOrderingMatchingRuleOID() {
        return ORDERING_RULE_OID;
    }

    @Override
    public String getSubstringMatchingRuleName() {
        return null;
    }

    @Override
    public String getSubstringMatchingRuleOID() {
        return null;
    }

    @Override
    public boolean valuesMatch(ASN1OctetString value1, ASN1OctetString value2) throws LDAPException {
        return this.normalize(value1).equals(this.normalize(value2));
    }

    @Override
    public boolean matchesAnyValue(ASN1OctetString assertionValue, ASN1OctetString[] attributeValues) throws LDAPException {
        if (assertionValue == null || attributeValues == null || attributeValues.length == 0) {
            return false;
        }
        ASN1OctetString normalizedAssertionValue = this.normalize(assertionValue);
        for (ASN1OctetString attributeValue : attributeValues) {
            try {
                if (!normalizedAssertionValue.equalsIgnoreType(this.normalize(attributeValue))) continue;
                return true;
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        return false;
    }

    @Override
    public boolean matchesSubstring(ASN1OctetString value, ASN1OctetString subInitial, ASN1OctetString[] subAny, ASN1OctetString subFinal) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_INTEGER_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }

    @Override
    public int compareValues(ASN1OctetString value1, ASN1OctetString value2) throws LDAPException {
        byte[] norm1Bytes = this.normalize(value1).getValue();
        byte[] norm2Bytes = this.normalize(value2).getValue();
        if (norm1Bytes[0] == 45) {
            if (norm2Bytes[0] == 45) {
                if (norm1Bytes.length < norm2Bytes.length) {
                    return 1;
                }
                if (norm1Bytes.length > norm2Bytes.length) {
                    return -1;
                }
                for (int i = 1; i < norm1Bytes.length; ++i) {
                    int difference = norm2Bytes[i] - norm1Bytes[i];
                    if (difference == 0) continue;
                    return difference;
                }
                return 0;
            }
            return -1;
        }
        if (norm2Bytes[0] == 45) {
            return 1;
        }
        if (norm1Bytes.length < norm2Bytes.length) {
            return -1;
        }
        if (norm1Bytes.length > norm2Bytes.length) {
            return 1;
        }
        for (int i = 0; i < norm1Bytes.length; ++i) {
            int difference = norm1Bytes[i] - norm2Bytes[i];
            if (difference == 0) continue;
            return difference;
        }
        return 0;
    }

    @Override
    public ASN1OctetString normalize(ASN1OctetString value) throws LDAPException {
        byte[] valueBytes = value.getValue();
        if (valueBytes.length == 0) {
            throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_ZERO_LENGTH_NOT_ALLOWED.get());
        }
        if (valueBytes[0] == 32 || valueBytes[valueBytes.length - 1] == 32) {
            String valueStr = value.stringValue().trim();
            if (valueStr.isEmpty()) {
                throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_ZERO_LENGTH_NOT_ALLOWED.get());
            }
            block10: for (int i = 0; i < valueStr.length(); ++i) {
                switch (valueStr.charAt(i)) {
                    case '-': {
                        if (i == 0 && valueStr.length() != 1) continue block10;
                        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_CHARACTER.get(i));
                    }
                    case '0': {
                        if ((i != 0 || valueStr.length() <= 1) && (i != 1 || valueStr.charAt(0) != '-')) continue block10;
                        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_LEADING_ZERO.get());
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        continue block10;
                    }
                    default: {
                        throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_CHARACTER.get(i));
                    }
                }
            }
            return new ASN1OctetString(valueStr);
        }
        block11: for (int i = 0; i < valueBytes.length; ++i) {
            switch (valueBytes[i]) {
                case 45: {
                    if (i == 0 && valueBytes.length != 1) continue block11;
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_CHARACTER.get(i));
                }
                case 48: {
                    if ((i != 0 || valueBytes.length <= 1) && (i != 1 || valueBytes[0] != 45)) continue block11;
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_LEADING_ZERO.get());
                }
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    continue block11;
                }
                default: {
                    throw new LDAPException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, MatchingRuleMessages.ERR_INTEGER_INVALID_CHARACTER.get(i));
                }
            }
        }
        return value;
    }

    @Override
    public ASN1OctetString normalizeSubstring(ASN1OctetString value, byte substringType) throws LDAPException {
        throw new LDAPException(ResultCode.INAPPROPRIATE_MATCHING, MatchingRuleMessages.ERR_INTEGER_SUBSTRING_MATCHING_NOT_SUPPORTED.get());
    }
}

