/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.lz4.ESLZ4Compressor;
import org.elasticsearch.lz4.ESLZ4Decompressor;
import org.elasticsearch.transport.ReuseBuffersLZ4BlockOutputStream;

public class Compression {

    public static enum Enabled {
        TRUE,
        INDEXING_DATA,
        FALSE;

    }

    public static enum Scheme {
        LZ4,
        DEFLATE;

        static final Version LZ4_VERSION;
        static final int HEADER_LENGTH = 4;
        private static final byte[] DEFLATE_HEADER;
        private static final byte[] LZ4_HEADER;
        private static final int LZ4_BLOCK_SIZE;
        private static final boolean USE_FORKED_LZ4;

        public static boolean isDeflate(BytesReference bytes) {
            byte firstByte = bytes.get(0);
            if (firstByte != DEFLATE_HEADER[0]) {
                return false;
            }
            return Scheme.validateHeader(bytes, DEFLATE_HEADER);
        }

        public static boolean isLZ4(BytesReference bytes) {
            byte firstByte = bytes.get(0);
            if (firstByte != LZ4_HEADER[0]) {
                return false;
            }
            return Scheme.validateHeader(bytes, LZ4_HEADER);
        }

        private static boolean validateHeader(BytesReference bytes, byte[] header) {
            for (int i = 1; i < 4; ++i) {
                if (bytes.get(i) == header[i]) continue;
                return false;
            }
            return true;
        }

        public static LZ4FastDecompressor lz4Decompressor() {
            if (USE_FORKED_LZ4) {
                return ESLZ4Decompressor.INSTANCE;
            }
            return LZ4Factory.safeInstance().fastDecompressor();
        }

        public static OutputStream lz4OutputStream(OutputStream outputStream) throws IOException {
            outputStream.write(LZ4_HEADER);
            LZ4Compressor lz4Compressor = USE_FORKED_LZ4 ? ESLZ4Compressor.INSTANCE : LZ4Factory.safeInstance().fastCompressor();
            return new ReuseBuffersLZ4BlockOutputStream(outputStream, LZ4_BLOCK_SIZE, lz4Compressor);
        }

        static {
            LZ4_VERSION = Version.V_7_14_0;
            DEFLATE_HEADER = new byte[]{68, 70, 76, 0};
            LZ4_HEADER = new byte[]{76, 90, 52, 0};
            String blockSizeString = System.getProperty("es.transport.compression.lz4_block_size");
            if (blockSizeString != null) {
                int lz4BlockSize = Integer.parseInt(blockSizeString);
                if (lz4BlockSize < 1024 || lz4BlockSize > 524288) {
                    throw new IllegalArgumentException("lz4_block_size must be >= 1KB and <= 512KB");
                }
                LZ4_BLOCK_SIZE = lz4BlockSize;
            } else {
                LZ4_BLOCK_SIZE = 65536;
            }
            USE_FORKED_LZ4 = Booleans.parseBoolean(System.getProperty("es.compression.use_forked_lz4", "true"));
        }
    }
}

