/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.security.action.privilege.ApplicationPrivilegesRequest;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.support.StringMatcher;
import org.elasticsearch.xpack.core.security.xcontent.XContentUtils;

public final class ConfigurableClusterPrivileges {
    public static final ConfigurableClusterPrivilege[] EMPTY_ARRAY = new ConfigurableClusterPrivilege[0];
    public static final Writeable.Reader<ConfigurableClusterPrivilege> READER = in1 -> in1.readNamedWriteable(ConfigurableClusterPrivilege.class);
    public static final Writeable.Writer<ConfigurableClusterPrivilege> WRITER = (out1, value) -> out1.writeNamedWriteable((NamedWriteable)value);

    private ConfigurableClusterPrivileges() {
    }

    public static ConfigurableClusterPrivilege[] readArray(StreamInput in) throws IOException {
        return in.readArray(READER, ConfigurableClusterPrivilege[]::new);
    }

    public static void writeArray(StreamOutput out, ConfigurableClusterPrivilege[] privileges) throws IOException {
        out.writeArray(WRITER, privileges);
    }

    public static XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params, Collection<ConfigurableClusterPrivilege> privileges) throws IOException {
        builder.startObject();
        for (ConfigurableClusterPrivilege.Category category : ConfigurableClusterPrivilege.Category.values()) {
            builder.startObject(category.field.getPreferredName());
            for (ConfigurableClusterPrivilege privilege : privileges) {
                if (category != privilege.getCategory()) continue;
                privilege.toXContent(builder, params);
            }
            builder.endObject();
        }
        return builder.endObject();
    }

    public static List<ConfigurableClusterPrivilege> parse(XContentParser parser) throws IOException {
        ArrayList<ConfigurableClusterPrivilege> privileges = new ArrayList<ConfigurableClusterPrivilege>();
        ConfigurableClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.START_OBJECT);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            ConfigurableClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.FIELD_NAME);
            ConfigurableClusterPrivileges.expectFieldName(parser, ConfigurableClusterPrivilege.Category.APPLICATION.field);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_OBJECT);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.FIELD_NAME);
            ConfigurableClusterPrivileges.expectFieldName(parser, ManageApplicationPrivileges.Fields.MANAGE);
            privileges.add(ManageApplicationPrivileges.parse(parser));
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.END_OBJECT);
        }
        return privileges;
    }

    private static void expectedToken(XContentParser.Token read, XContentParser parser, XContentParser.Token expected) {
        if (read != expected) {
            throw new XContentParseException(parser.getTokenLocation(), "failed to parse privilege. expected [" + (Object)((Object)expected) + "] but found [" + (Object)((Object)read) + "] instead");
        }
    }

    private static void expectFieldName(XContentParser parser, ParseField ... fields) throws IOException {
        String fieldName = parser.currentName();
        if (!Arrays.stream(fields).anyMatch(pf -> pf.match(fieldName, parser.getDeprecationHandler()))) {
            throw new XContentParseException(parser.getTokenLocation(), "failed to parse privilege. expected " + (fields.length == 1 ? "field name" : "one of") + " [" + Strings.arrayToCommaDelimitedString(fields) + "] but found [" + fieldName + "] instead");
        }
    }

    public static class ManageApplicationPrivileges
    implements ConfigurableClusterPrivilege {
        public static final String WRITEABLE_NAME = "manage-application-privileges";
        private final Set<String> applicationNames;
        private final Predicate<String> applicationPredicate;
        private final Predicate<TransportRequest> requestPredicate;

        public ManageApplicationPrivileges(Set<String> applicationNames) {
            this.applicationNames = Collections.unmodifiableSet(applicationNames);
            this.applicationPredicate = StringMatcher.of(applicationNames);
            this.requestPredicate = request -> {
                if (request instanceof ApplicationPrivilegesRequest) {
                    ApplicationPrivilegesRequest privRequest = (ApplicationPrivilegesRequest)((Object)request);
                    Collection<String> requestApplicationNames = privRequest.getApplicationNames();
                    return requestApplicationNames.isEmpty() ? this.applicationNames.contains("*") : requestApplicationNames.stream().allMatch(application -> this.applicationPredicate.test((String)application));
                }
                return false;
            };
        }

        @Override
        public ConfigurableClusterPrivilege.Category getCategory() {
            return ConfigurableClusterPrivilege.Category.APPLICATION;
        }

        public Collection<String> getApplicationNames() {
            return Collections.unmodifiableCollection(this.applicationNames);
        }

        @Override
        public String getWriteableName() {
            return WRITEABLE_NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.applicationNames, StreamOutput::writeString);
        }

        public static ManageApplicationPrivileges createFrom(StreamInput in) throws IOException {
            Set<String> applications = in.readSet(StreamInput::readString);
            return new ManageApplicationPrivileges(applications);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.field(Fields.MANAGE.getPreferredName(), Collections.singletonMap(Fields.APPLICATIONS.getPreferredName(), this.applicationNames));
        }

        public static ManageApplicationPrivileges parse(XContentParser parser) throws IOException {
            ConfigurableClusterPrivileges.expectedToken(parser.currentToken(), parser, XContentParser.Token.FIELD_NAME);
            ConfigurableClusterPrivileges.expectFieldName(parser, new ParseField[]{Fields.MANAGE});
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_OBJECT);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.FIELD_NAME);
            ConfigurableClusterPrivileges.expectFieldName(parser, new ParseField[]{Fields.APPLICATIONS});
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.START_ARRAY);
            String[] applications = XContentUtils.readStringArray(parser, false);
            ConfigurableClusterPrivileges.expectedToken(parser.nextToken(), parser, XContentParser.Token.END_OBJECT);
            return new ManageApplicationPrivileges(new LinkedHashSet<String>(Arrays.asList(applications)));
        }

        public String toString() {
            return "{" + (Object)((Object)this.getCategory()) + ":" + Fields.MANAGE.getPreferredName() + ":" + Fields.APPLICATIONS.getPreferredName() + "=" + Strings.collectionToDelimitedString(this.applicationNames, ",") + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManageApplicationPrivileges that = (ManageApplicationPrivileges)o;
            return this.applicationNames.equals(that.applicationNames);
        }

        public int hashCode() {
            return this.applicationNames.hashCode();
        }

        @Override
        public ClusterPermission.Builder buildPermission(ClusterPermission.Builder builder) {
            return builder.add((ClusterPrivilege)this, Collections.singleton("cluster:admin/xpack/security/privilege/*"), this.requestPredicate);
        }

        private static interface Fields {
            public static final ParseField MANAGE = new ParseField("manage", new String[0]);
            public static final ParseField APPLICATIONS = new ParseField("applications", new String[0]);
        }
    }
}

