/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.client;

import java.util.Map;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.DeleteWatchResponse;
import org.elasticsearch.protocol.xpack.watcher.PutWatchRequest;
import org.elasticsearch.protocol.xpack.watcher.PutWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.ack.AckWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.activate.ActivateWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.delete.DeleteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.delete.DeleteWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.execute.ExecuteWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.get.GetWatchResponse;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.PutWatchAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.put.PutWatchRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.service.WatcherServiceRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsAction;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsRequestBuilder;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsResponse;

public class WatcherClient {
    private final Client client;

    public WatcherClient(Client client) {
        this.client = client;
    }

    public GetWatchRequestBuilder prepareGetWatch(String id) {
        return new GetWatchRequestBuilder(this.client, id);
    }

    public GetWatchRequestBuilder prepareGetWatch() {
        return new GetWatchRequestBuilder(this.client);
    }

    public void getWatch(GetWatchRequest request, ActionListener<GetWatchResponse> listener) {
        this.client.execute(GetWatchAction.INSTANCE, request, listener);
    }

    public ActionFuture<GetWatchResponse> getWatch(GetWatchRequest request) {
        return this.client.execute(GetWatchAction.INSTANCE, request);
    }

    public DeleteWatchRequestBuilder prepareDeleteWatch(String id) {
        return new DeleteWatchRequestBuilder(this.client, id);
    }

    public DeleteWatchRequestBuilder prepareDeleteWatch() {
        return new DeleteWatchRequestBuilder(this.client);
    }

    public void deleteWatch(DeleteWatchRequest request, ActionListener<DeleteWatchResponse> listener) {
        this.client.execute(DeleteWatchAction.INSTANCE, request, listener);
    }

    public ActionFuture<DeleteWatchResponse> deleteWatch(DeleteWatchRequest request) {
        return this.client.execute(DeleteWatchAction.INSTANCE, request);
    }

    public PutWatchRequestBuilder preparePutWatch(String id) {
        return new PutWatchRequestBuilder(this.client, id);
    }

    public PutWatchRequestBuilder preparePutWatch() {
        return new PutWatchRequestBuilder(this.client);
    }

    public void putWatch(PutWatchRequest request, ActionListener<PutWatchResponse> listener) {
        this.client.execute(PutWatchAction.INSTANCE, request, listener);
    }

    public ActionFuture<PutWatchResponse> putWatch(PutWatchRequest request) {
        return this.client.execute(PutWatchAction.INSTANCE, request);
    }

    public ActionFuture<WatcherStatsResponse> watcherStats(WatcherStatsRequest request) {
        return this.client.execute(WatcherStatsAction.INSTANCE, request);
    }

    public WatcherStatsRequestBuilder prepareWatcherStats() {
        return new WatcherStatsRequestBuilder(this.client);
    }

    public void watcherStats(WatcherStatsRequest request, ActionListener<WatcherStatsResponse> listener) {
        this.client.execute(WatcherStatsAction.INSTANCE, request, listener);
    }

    public AckWatchRequestBuilder prepareAckWatch(String id) {
        return new AckWatchRequestBuilder(this.client, id);
    }

    public void ackWatch(AckWatchRequest request, ActionListener<AckWatchResponse> listener) {
        this.client.execute(AckWatchAction.INSTANCE, request, listener);
    }

    public ActionFuture<AckWatchResponse> ackWatch(AckWatchRequest request) {
        return this.client.execute(AckWatchAction.INSTANCE, request);
    }

    public ActivateWatchRequestBuilder prepareActivateWatch(String id, boolean activate) {
        return new ActivateWatchRequestBuilder((ElasticsearchClient)this.client, id, activate);
    }

    public void activateWatch(ActivateWatchRequest request, ActionListener<ActivateWatchResponse> listener) {
        this.client.execute(ActivateWatchAction.INSTANCE, request, listener);
    }

    public ActionFuture<ActivateWatchResponse> activateWatch(ActivateWatchRequest request) {
        return this.client.execute(ActivateWatchAction.INSTANCE, request);
    }

    public WatcherServiceRequestBuilder prepareWatchService() {
        return new WatcherServiceRequestBuilder(this.client);
    }

    public void watcherService(WatcherServiceRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute(WatcherServiceAction.INSTANCE, request, listener);
    }

    public ActionFuture<AcknowledgedResponse> watcherService(WatcherServiceRequest request) {
        return this.client.execute(WatcherServiceAction.INSTANCE, request);
    }

    public ExecuteWatchRequestBuilder prepareExecuteWatch(String id) {
        return new ExecuteWatchRequestBuilder(this.client, id);
    }

    public ExecuteWatchRequestBuilder prepareExecuteWatch() {
        return new ExecuteWatchRequestBuilder(this.client);
    }

    public void executeWatch(ExecuteWatchRequest request, ActionListener<ExecuteWatchResponse> listener) {
        this.client.execute(ExecuteWatchAction.INSTANCE, request, listener);
    }

    public ActionFuture<ExecuteWatchResponse> executeWatch(ExecuteWatchRequest request) {
        return this.client.execute(ExecuteWatchAction.INSTANCE, request);
    }

    public WatcherClient filterWithHeader(Map<String, String> headers) {
        return new WatcherClient(this.client.filterWithHeader(headers));
    }
}

