/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.execution.search.extractor;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class ComputingExtractor
implements HitExtractor,
BucketExtractor {
    static final String NAME = "p";
    private final Processor processor;
    private final String hitName;

    public ComputingExtractor(Processor processor) {
        this(processor, null);
    }

    public ComputingExtractor(Processor processor, String hitName) {
        this.processor = processor;
        this.hitName = hitName;
    }

    public ComputingExtractor(StreamInput in) throws IOException {
        this.processor = in.readNamedWriteable(Processor.class);
        this.hitName = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.processor);
        out.writeOptionalString(this.hitName);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public Processor processor() {
        return this.processor;
    }

    public Object extract(Object input) {
        return this.processor.process(input);
    }

    @Override
    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        return this.processor.process(bucket);
    }

    @Override
    public Object extract(SearchHit hit) {
        return this.processor.process(hit);
    }

    @Override
    public String hitName() {
        return this.hitName;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ComputingExtractor other = (ComputingExtractor)obj;
        return Objects.equals(this.processor, other.processor) && Objects.equals(this.hitName, other.hitName);
    }

    public int hashCode() {
        return Objects.hash(this.processor, this.hitName);
    }

    public String toString() {
        return this.processor.toString();
    }
}

